<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */

class ForwardBooking extends Eloquent {
    protected $table = "flights__forward_booking";
    public $timestamps = true;

    public function aircraft(){
        return $this->belongsTo('App\Models\Aircraft','aircraft_id');
    }

    public function flightNumber(){
        return $this->belongsTo('App\Models\FlightNumber', 'flight_number_id');
    }

    public function flight(){
        return $this->belongsTo('App\Models\Flight', 'flight_id');
    }


    public static function Pax_Bound_Std($last_updated_date){

        $pax_by_std = ForwardBooking::join('aircraft', 'forward_booking.aircraft_id','=','aircraft.id')
            ->join('flights__numbers','forward_booking.flight_number_id','=','flights__numbers.id')
            ->selectRaw('DATE(std) AS departure_date,
                            SUM(IF(bound = "0", config_c,0)) as capacity_c_outbound, SUM(IF(bound = "0", config_y,0)) as capacity_y_outbound,
                            SUM(IF(bound = "1", config_c,0)) as capacity_c_inbound, SUM(IF(bound = "1", config_y,0)) as capacity_y_inbound,
                            SUM(IF(bound = "0", pax_c_booked,0)) as pax_c_booked_outbound,SUM(IF(bound = "0", pax_y_booked,0)) as pax_y_booked_outbound,
                            SUM(IF(bound = "1", pax_c_booked,0)) as pax_c_booked_inbound,SUM(IF(bound = "1", pax_y_booked,0)) as pax_y_booked_inbound,
                            SUM(config_c) as capacity_c, SUM(config_y) as capacity_y, SUM(pax_c_booked) as pax_c_booked, SUM(pax_y_booked) as pax_y_booked')
            ->where('updated_date', $last_updated_date)
            ->groupBy('departure_date')
            ->get()
            ->toArray();

        foreach ($pax_by_std as $i=>$each) {
            if (($each['capacity_c_outbound'] + $each['capacity_y_outbound']) == 0)
                $pax_by_std[$i]['sf_outbound'] = 0;
            else
                $pax_by_std[$i]['sf_outbound'] = round(($each['pax_c_booked_outbound'] + $each['pax_y_booked_outbound']) * 100/($each['capacity_c_outbound'] + $each['capacity_y_outbound']));

            if (($each['capacity_c_inbound'] + $each['capacity_y_inbound']) == 0)
                $pax_by_std[$i]['sf_inbound'] = 0;
            else
                $pax_by_std[$i]['sf_inbound'] = round(($each['pax_c_booked_inbound'] + $each['pax_y_booked_inbound']) * 100/($each['capacity_c_inbound'] + $each['capacity_y_inbound']));
            if (($each['capacity_c'] + $each['capacity_y']) == 0)
                $pax_by_std[$i]['sf'] = 0;
            else
                $pax_by_std[$i]['sf'] = round(($each['pax_c_booked'] + $each['pax_y_booked']) * 100/($each['capacity_c'] + $each['capacity_y']));
        }

        return $pax_by_std;
    }
}
