<?php namespace App\Models; use App\Classes\RadarBox\RadarBoxParse;
use Illuminate\Database\Eloquent\Model as Eloquent;
use PhpSpec\Exception\Exception;

/**
 * Created by PhpStorm.

 */

class FlightTrackerDetail extends Eloquent{

    protected $table = "flights__tracker_details";

    public $timestamps = true;

    protected $guarded = [
        "id",
        "created_at",
        "updated_at"
    ];

    protected static $fields = [
        "fch"                   => "timestamp",
        "fal"                   => "double",
        "fgs"                   => "double",
        "fhd"                   => "double",
        "fla"                   => "double",
        "flo"                   => "double",
        "uipla"                 => "double",
        "uiplo"                 => "double",
        "fdistorgtodst"         => "double",
        "fdistfromorg"          => "double",
        "fdisttodst"            => "double",
        "fpgr"                  => "double",
        "usr"                   => "double",
    ];

    public static function getFields(){
        return self::$fields;
    }

    public static function createNew (FlightTracker $flightTracker, $data, Flight $flight){

        $trackerDetails = new FlightTrackerDetail();
        $trackerDetails->flight_tracker_id = $flightTracker->id;
        $trackerDetails->flight_id = $flight->id;

        foreach (self::getFields() as $field => $type) {

            try {
                // if isset field
                if ($data->{$field} && (string)$data->{$field}) {

                    switch ($type) {
                        case TIMESTAMP:
                            $trackerDetails->{$field} = RadarBoxParse::parseDateTime((string)$data->{$field});
                            break;

                        default:
                            $trackerDetails->{$field} = (string)$data->{$field};
                            break;
                    }
                }
            }
            catch(\Exception $e){
                debug($e->getMessage());
            }
        }

        $trackerDetails->save();

    }
}
