<?php namespace App\Models; use App\Classes\RadarBox\RadarBoxParse;
use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

class FlightTracker extends Eloquent{

    protected $table = "flights__tracker";

    public $timestamps = true;

    protected $guarded = [
        "id",
        "created_at",
        "updated_at"
    ];

    // with type
    protected static $fields = [
        // Feed 3
            // Change Column Names
        "forgtime_s"            => ["datetime", "std"],
        "forgtime_e"            => ["datetime", "etd"],
        "forgtime_a"            => ["datetime", "atd"],
        "fdsttime_s"            => ["datetime", "sta"],
        "fdsttime_e"            => ["datetime", "eta"],
        "fdsttime_a"            => ["datetime", "ata"],

        "fch"                   => "timestamp",
        "fms"                   => "string",
        "fsq"                   => "string",
        "cn"                    => "string",
        "forg"                  => "string",
        "forgiata"              => "string",
        "forglat"               => "double",
        "forglon"               => "double",
        "fdst"                  => "string",
        "fdstiata"              => "string",
        "fdstlat"               => "double",
        "fdstlon"               => "double",
        "lngapt"                => "string",
        "lngrwy"                => "string",
        "lngtime"               => "timestamp",
        "tkoapt"                => "string",
        "tkorwy"                => "string",
        "tkotime"               => "timestamp",
        "usr"                   => "string",
        "usc"                   => "string",
        "isblocked"             => "string",
        "faccat"                => "string",
        "fuscat"                => "string",
        "isga"                  => "string",
        "froute"                => "string",
        "fwaypoints"            => "string",
        "fdistorgtodst"         => "double",

        // Feed 4
        "status"                => "string",
        "forgtimezone"          => "integer",
        "fdsttimezone"          => "integer",
        "fat"                   => "string",
        "fat_s"                 => "string",
        "fat_a"                 => "string",
        "forggate"              => "string",

        "forgterminal"          => "string",
        "fdstgate"              => "string",
        "fdstterminal"          => "string",
        "fdstbaggageclaim"      => "string",

    ];

    public static function getFields(){
        return self::$fields;
    }

    public static function createOrUpdate($data, Flight $flight, FlightTracker $tracker = null, Airline $airline = null, Aircraft $aircraft = null, AircraftType $aircraftType = null){
        if (!$tracker){
            $tracker = new FlightTracker();
            $tracker->flight_id = $flight->id;
            $tracker->flight_number_id = $flight->flight_number_id;
        }
        if ($airline){
            $tracker->airline_id = $airline->id;
        }
        if ($aircraft){
            $tracker->aircraft_id = $aircraft->id;
        }
        if ($aircraftType){
            $tracker->aircraft_type_id = $aircraftType->id;
        }

        foreach (self::getFields() as $field => $typeField) {

            // if isset field
            if ((string)$data->{$field}){

                $type = is_array($typeField) ? $typeField[0] : $typeField;
                $fieldName = is_array($typeField) ? $typeField[1] : $field;

                switch($type){
                    case TIMESTAMP:
                        $tracker->{$fieldName} = RadarBoxParse::parseDateTime((string)$data->{$field});
                        break;

                    default:
                        $tracker->{$fieldName} = (string)$data->{$field};
                        break;
                }

            }
        }

        $tracker->save();

        return $tracker;
    }
}
