<?php namespace App\Models; use App\Classes\Parsing\ParseEmail;
use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\Auth;

/**
 * Created by PhpStorm.

 */
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class FlightStation extends Eloquent implements AuditableContract{

    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "flights__stations";

    public $timestamps = true;

    public static function updateFlightStations(Flight $flight, $sentDate, $data, ParseEmail $parseEmail = null)
    {
        if ($data) {
            $fStations = FlightStation::where("flight_id", $flight->id)
                                        ->get();
            // Audit Deleted
            auditDeleted($fStations);


            foreach ($data as $each) {
                $flightStation = new FlightStation();
                $flightStation->flight_id           = $each['flight_id'];
                $flightStation->flight_number_id    = isset($each['flight_number_id']) ? $each['flight_number_id'] : null;

                if ($parseEmail){
                    $flightStation->email_id        = $parseEmail->messageId;
                }
                else {
                    $flightStation->created_by      = Auth::user() != null ? Auth::user()->id : null;
                }

                $flightStation->email_type          = isset($each['email_type'])    ? $each['email_type']   : null;
                $flightStation->airport_id          = isset($each['airport_id'])    ? $each['airport_id']   : null;
                $flightStation->airport             = isset($each['airport'])       ? $each['airport']      : null;
                $flightStation->received_datetime   = $sentDate;
                $flightStation->pax_m               = isset($each['paxM'])          ? $each['paxM']         : null;
                $flightStation->pax_f               = isset($each['paxF'])          ? $each['paxF']         : null;
                $flightStation->pax_ch              = isset($each['paxCh'])         ? $each['paxCh']        : null;
                $flightStation->pax_inf             = isset($each['paxInf'])        ? $each['paxInf']       : null;
                $flightStation->pax_c               = isset($each['paxC'])          ? $each['paxC']         : null;
                $flightStation->pax_y               = isset($each['paxY'])          ? $each['paxY']         : null;
                $flightStation->baggage             = isset($each['baggage'])       ? $each['baggage']      : null;
                $flightStation->baggage_pcs         = isset($each['baggage_pcs'])   ? $each['baggage_pcs']  : null;
                $flightStation->cargo               = isset($each['cargo'])         ? $each['cargo']        : null;
                $flightStation->eic                 = isset($each['eic'])           ? $each['eic']          : null;
                $flightStation->mail                = isset($each['mail'])          ? $each['mail']         : null;

                $flightStation->cmp_total_wt        = isset($each['totalWt'])          ? $each['totalWt']         : null;
                $flightStation->cmp_1_wt            = isset($each['comp1Wt'])          ? $each['comp1Wt']         : null;
                $flightStation->cmp_2_wt            = isset($each['comp2Wt'])          ? $each['comp2Wt']         : null;
                $flightStation->cmp_3_wt            = isset($each['comp3Wt'])          ? $each['comp3Wt']         : null;
                $flightStation->cmp_4_wt            = isset($each['comp4Wt'])          ? $each['comp4Wt']         : null;
                $flightStation->cmp_5_wt            = isset($each['comp5Wt'])          ? $each['comp5Wt']         : null;

                $flightStation->save();
            }
        }
    }
}
