<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\DB;

/**
 * Created by PhpStorm.

 */

class FlightSector extends Eloquent{

    protected $table = "flights__sectors";

    public $timestamps = true;

    /**
     * List Sectors (Filters: Flight Type, Airport Name) And Choose Array Key
     * @return mixed
     */
    public static function listSectors(){
        return FlightSector::join('airports as depAirport', 'flights__sectors.from_airport_id', '=', 'depAirport.id')
                            ->join('airports as arrAirport', 'flights__sectors.to_airport_id', '=', 'arrAirport.id')
                            ->whereNotNull('depAirport.iata')
                            ->whereNotNull('arrAirport.iata')
                            ->get([
                                'flights__sectors.id as id',
                                DB::raw('CONCAT(s_depAirport.iata, "-", s_arrAirport.iata) AS sector')
                            ])
                            ->pluck('sector', 'id')
                            ->all();
    }

    public static function getSectorsByAirlines(){
        $sectors = FlightNumber::select([
                                "airline_id",
                                "flight_sector_id as id",
                                DB::raw('CONCAT(s_depAirport.iata, "-", s_arrAirport.iata) AS sector'),
                            ])
                            ->join('airports as depAirport', 'flights__numbers.departure_airport_id', '=', 'depAirport.id')
                            ->join('airports as arrAirport', 'flights__numbers.arrival_airport_id', '=', 'arrAirport.id')
                            ->whereNull("flights__numbers.deleted_at")
                            ->whereNotNull("flight_sector_id")
                            ->whereNotNull("airline_id")
                            ->groupBy("airline_id", "id", "sector")
                            ->get();

        return $sectors;
    }


    public static function listSectorsByAP($operated = false){
        if ($operated){
            $handlingStations = Airport::getOperatedStations();
        }
        else{
            $handlingStations = Airport::getHandlingStations();
        }

        $flightSectors = FlightSector::join('airports as depAirport', 'flights__sectors.from_airport_id', '=', 'depAirport.id')
            ->join('airports as arrAirport', 'flights__sectors.to_airport_id', '=', 'arrAirport.id')
            ->select([
                'flights__sectors.id as id',
                'from_airport_id AS departure_airport_id',
                'to_airport_id AS arrival_airport_id',
                'depAirport.iata AS depAirport',
                'arrAirport.iata AS arrAirport'
            ])
            ->where(function($sql) use ($handlingStations){
               $sql->whereIn("depAirport.id", $handlingStations)
                   ->orWhereIn("arrAirport.id", $handlingStations);
             })
            ->whereNotNull('depAirport.iata')
            ->whereNotNull('arrAirport.iata')
            ->get();


        $operatedAPs = [];
        foreach ($flightSectors as $each) {
            // OUTBOUND FLT
            if (in_array($each->departure_airport_id, $handlingStations)){
                if (!isset($operatedAPs[$each->depAirport])){
                    $operatedAPs[$each->depAirport] = [];
                }

                if (!in_array($each->arrAirport, $operatedAPs[$each->depAirport])){
                    $operatedAPs[$each->depAirport][] = $each->arrAirport;
                }
            }
            // INBOUND
            else {
                if (!isset($operatedAPs[$each->arrAirport])){
                    $operatedAPs[$each->arrAirport] = [];
                }

                if (!in_array($each->depAirport, $operatedAPs[$each->arrAirport])){
                    $operatedAPs[$each->arrAirport][] = $each->depAirport;
                }
            }
        }

       return $operatedAPs;

    }

}
