<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: intranet.dev
 */

class FlightScheduleFlight extends Eloquent
{
    protected $table = "flights__schedule_flights";
    protected $guarded = [
        "created_at",
        "updated_at",
        "id"
    ];
    public $timestamps = TRUE;

    public function flightSchedule()
    {
        return $this->belongsTo("App\\Models\\FlightSchedule", "flight_schedule_id");
    }

    public function updatedBy()
    {
        return $this->belongsTo("App\\Models\\User", "updated_by");
    }

    public function createdBy()
    {
        return $this->belongsTo("App\\Models\\User", "created_by");
    }

    /**
     * Aircraft
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function aircraft()
    {
        return $this->belongsTo("App\\Models\\Aircraft", "aircraft_id");
    }

    public function aircraftType()
    {
        return $this->belongsTo("App\\Models\\AircraftType", "aircraft_type_id");
    }

    public function airline()
    {
        return $this->belongsTo("App\\Models\\Airline", "airline_id");
    }

    /**
     * Flight Number
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function flightNumber()
    {
        return $this->belongsTo("App\\Models\\FlightNumber", "flight_number_id");
    }
}
