<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: intranet.dev
 */

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class FlightScheduleAirline extends Eloquent implements AuditableContract
{
    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "flights__schedule_airlines";

    protected $guarded = [
        "created_at",
        "updated_at",
        "id"
    ];

    public $timestamps = TRUE;

    public function airline(){
        return $this->belongsTo(Airline::class, "airline_id");
    }

    public function flights($schedule_id, $airline_id){
        return FlightScheduleFlight::where("flight_schedule_id", $schedule_id)
                                    ->where("airline_id", $airline_id)
                                    ->get();
    }

}
