<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\DB;

/**
 * Created by PhpStorm.

 */

class FlightRoute extends Eloquent{

    protected $table = "flights__routes";

    public $timestamps = true;

    public function flightType(){
        return $this->belongsTo('App\Models\FlightType', 'flight_type_id');
    }

    public function fromAirport(){
        return $this->belongsTo('App\Models\Airport', 'from_airport_id');
    }

    public function toAirport(){
        return $this->belongsTo('App\Models\Airport', 'to_airport_id');
    }

    public static function listRoutes($routeWithID = false){

        $result = FlightRoute::join('airports as fromAirport', 'fromAirport.id', '=','flights__routes.from_airport_id')
            ->join('airports as toAirport', 'toAirport.id', '=','flights__routes.to_airport_id');

        if ($routeWithID){
            return $result
                ->orderBy('route')
                ->get([
                    DB::raw('CONCAT(s_fromAirport.iata, "-", s_toAirport.iata) as route'),
                    "flights__routes.id as id",
                ])
                ->pluck("route", "id")
                ->all();
        }

        return $result
            ->orderBy('route_from')
            ->orderBy('route_to')
            ->get([
            DB::raw('CONCAT(s_fromAirport.iata, "-", s_toAirport.iata) as route_from'),
            DB::raw('CONCAT(s_toAirport.iata, "-", s_fromAirport.iata) as route_to'),
            "flights__routes.id as id",
        ]);
    }


}
