<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 25.08.14

 */

class FlightPTS extends Eloquent
{
    protected $table = "flights__pts";

    public $timestamps = true;

    protected $guarded = ["id", "created_at", "updated_at"];

    public function flight(){
        return $this->belongsTo(Flight::class, "flight_id");
    }

    public static function updateFields(Request $request, $flightComDetails, $flightID){
        $authUserID = Auth::user()->id;

        $fields = $request->all();

        $skipFields = [
            "last_message_id",
            "flight_id",
            "flight_ids",
            "key",
        ];

        $record = FlightPTS::where("flight_id", $flightID)
                    ->whereNull("deleted_at")
                    ->first();

        if ($record) {
            $record->updated_by = $authUserID;
        }
        else {
            $record = new FlightPTS();
            $record->flight_id = $flightID;
            $record->created_by = $authUserID;
        }

        $pts = new FlightComFlightPTS();
        $pts->flight_com_id = $flightComDetails->flight_com_id;
        $pts->flight_com_details_id = $flightComDetails->id;
        $pts->flight_id = $flightID;
        $pts->created_by = $authUserID;

        $createObj = false;
        foreach ($fields as $index => $value) {
            if (in_array($index, $skipFields)){
                continue;
            }

            if ($value || $value === "0"){
                $pts->{$index} = $value;
                $record->{$index} = $value;

                $createObj = true;
            }
        }

        if ($createObj) {
            // save
            $pts->save();

            // save
            $record->save();
        }

        return $createObj;
    }
}
