<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class FlightHBG extends Eloquent implements AuditableContract {

    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "flights__hbg";

    public $timestamps = true;

    protected $guarded = [
        "id",
        "created_at",
        "updated_at"
    ];

    public static function createRecord($flight, $seat, $tagNumber){
        $hbg = new FlightHBG();
        $hbg->flight_id = $flight->id;
        $hbg->seat_number  = $seat;
        $hbg->tag_number = $tagNumber;
        $hbg->save();
    }

    public static function addRecords($flight, $seatNumbers, $tagNumbers){

        $flight = Flight::with(["hbg"])->find($flight->id);

        $hbgs = $flight->hbg;

        if (!$hbgs){
            foreach ($seatNumbers as $i => $seat) {
                self::createRecord($flight, $seat, $tagNumbers[$i]);
            }
        }
        else {
            foreach ($seatNumbers as $i => $seat) {
                $hbg = $hbgs->where("seat_number", $seat)->first();

                // create if not
                if (!$hbg){
                    self::createRecord($flight, $seat, $tagNumbers[$i]);
                }
                // Update if exists
                else {
                    $hbg->tag_number = $tagNumbers[$i];
                    $hbg->save();
                }
            }

            // Remove others
            $fHBG = FlightHBG::where("flight_id", $flight->id)
                        ->whereNotIn("seat_number", $seatNumbers)
                        ->get();
            // Audit Deleted
            auditDeleted($fHBG);

        }
    }
}
