<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class FlightDelay extends Eloquent implements AuditableContract{

    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "flights__delays";

    protected $fillable = [
        'flight_id',
        'delay_id',
        'position',
        'duration'
    ];

    public $timestamps = true;

    public function delay(){
        return $this->belongsTo('App\Models\Delay', 'delay_id');
    }

    public function flight(){
        return $this->belongsTo('App\Models\Flight', 'flight_id');
    }

    public static function getFlightsByDelayChart($flightsByDelayCode){
        $flightsByDelayChart = [
            "delay"     => [],
            "value"     => []
        ];
        if ($flightsByDelayCode && count($flightsByDelayCode)) {
            foreach ($flightsByDelayCode as $index => $each) {
                $flightsByDelayChart["delay"][] = "DL $index"; // $each->delay_reason";
                $flightsByDelayChart["value"][] = $each->percentage;
            }
        }
        return $flightsByDelayChart;
    }
}
