<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

class FlightContainerInfo extends Eloquent{

    protected $table = "flights__containers_info";

    public $timestamps = true;

    public function flight()
    {
        return $this->belongsTo("App\\Models\\Flight", "flight_id");
    }

    public function cpmMessage()
    {
        return $this->belongsTo("App\\Models\\CPMMessage", "message_cpm_id");
    }

    public function flightContainer(){
        return $this->hasMany(FlightContainer::class, "info_id");
    }

    public static function getAll($flightIDs, $uldTypes = null, $uldNum = null){

        $result = FlightContainerInfo::with([
                                            'flight',
                                            'flight.flightNumber',
                                            'flightContainer',
                                            'flightContainer.container',
                                            'flightContainer.container.type'
                                        ])
                                        ->whereNull("manual");

        if ($uldTypes || $uldNum){

            $result->join("flights__containers", "flights__containers.info_id", "=", "flights__containers_info.id")
                   ->join("containers", "flights__containers.container_id", "=", "containers.id");

            if ($uldTypes) {
                $uldTypes = is_array($uldTypes) ? $uldTypes : [$uldTypes];
                if (count($uldTypes)){
                    $result->whereIn("containers.container_type_id", $uldTypes);
                }
            }

            if ($uldNum){
                $result->where("containers.num", $uldNum);
            }
        }

        return $result->whereIn("flight_id", $flightIDs)
                      ->get(["flights__containers_info.*"]);
    }


}
