<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\DB;

/**
 * Created by PhpStorm.

 */

class FlightContainer extends Eloquent{

    protected $table = "flights__containers";

    public $timestamps = true;

    public function info()
    {
        return $this->belongsTo(FlightContainerInfo::class, "info_id");
    }

    public function container()
    {
        return $this->belongsTo(Container::class, "container_id");
    }

    public function containerType()
    {
        return $this->belongsTo(ContainerType::class, "container_type_id");
    }

    public function destination()
    {
        return $this->belongsTo(Airport::class, "destination_airport_id");
    }

    public static function getAllByContainer($flightIDs, $containerID){

        $result = FlightContainer::with([
            'info',
            'container',
            'container.type'
        ])
            ->join("flights__containers_info", "flights__containers.info_id", "=", "flights__containers_info.id")
            ->join("flights", "flights.id", "=", "flights__containers_info.flight_id")
            ->where("container_id", $containerID)
            ->whereIn("flight_id", $flightIDs)
            ->orderBy("flights.std", "DESC")
            ->orderBy("flights.atd", "DESC")
            ->get([
                "flights__containers.*"
            ]);

        return $result;
    }

    public static function getAircraftCompartments($flightContainerInfo){

        $flightContainers = FlightContainer::with(['container', 'container.type', 'container.airline'])
            ->where("info_id", $flightContainerInfo->id)
            ->orderBy(DB::raw('CONCAT("", row_number)'), "DESC")
            ->orderBy("id")
            ->get();

//        debug($flightContainers);

        $compartments = $flightCompartments = [];
        $totalWidth = $totalWeight = 0;

        foreach ($flightContainers as $each) {
            // CPM is received
            if ($each->row_number){
                $compartmentNum = substr($each->row_number, 0, 1);

                // Sort to put P in front of L/R
                if (!isset($flightCompartments[$compartmentNum])){
                    $flightCompartments[$compartmentNum] = [];
                }

                $flightCompartments[$compartmentNum][$each->row_number.$each->position] = $each;

                // End
                $lengthAdded = false;

                if (!isset($compartments[$compartmentNum])){
                    $compartments[$compartmentNum] = new \stdClass();
                    $compartments[$compartmentNum]->containers = [];
                    $compartments[$compartmentNum]->row_numbers = [];
                    $compartments[$compartmentNum]->positions = [];
                    $compartments[$compartmentNum]->length = 0;
                    $compartments[$compartmentNum]->weight = 0;
                }

                $compartments[$compartmentNum]->weight += $each->weight;
                $totalWeight += $each->weight;

                if ($each->position == PALLET){
                    $compartments[$compartmentNum]->length += 2;

                    $lengthAdded = true;
                }
                else {
                    if (!in_array($each->row_number, $compartments[$compartmentNum]->row_numbers)) {
                        $compartments[$compartmentNum]->length += 1;
                        $lengthAdded = true;
                    }

                    $compartments[$compartmentNum]->row_numbers[] = $each->row_number;
                }

                $compartments[$compartmentNum]->containers[] = $each->row_number.$each->position;

                /*
                if ($each->position && !in_array($each->position, $compartments[$compartmentNum]->positions)){
                    $compartments[$compartmentNum]->positions[] = $each->position;
                }
                */
                if ($each->position){
                    if( !in_array($each->position, $compartments[$compartmentNum]->positions)) {

                        if (!$lengthAdded) {
                            switch ($each->position) {
                                case "L":
                                    if (!in_array("R", $compartments[$compartmentNum]->positions)) {
                                        $compartments[$compartmentNum]->length += 1;
                                    }
                                    break;

                                case "R":
                                    if (!in_array("L", $compartments[$compartmentNum]->positions)) {
                                        $compartments[$compartmentNum]->length += 1;
                                    }
                                    break;
                            }
                        }


                        $compartments[$compartmentNum]->positions[] = $each->position;
                    }
                }
                else {
                    // Only if not compartment 5 ->
                    // give length + 1 for without position items
                    if ($compartmentNum < 5 && !$lengthAdded){
                        $compartments[$compartmentNum]->length += 1;
                    }
                }

                if ($compartmentNum == 1){
                    // debug($compartments[$compartmentNum]);
                }
            }
            // ONLY When UCM is Received
            else {
                if (!isset($flightCompartments[""])){
                    $flightCompartments[""] = [];
                }
                $flightCompartments[""][] = $each;
            }
        }

        if (isset($compartments[5]) && count($compartments[5]->containers) == 1){
            $compartments[5]->length = 2;
        }

        foreach ($compartments as $num => $each) {
            $totalWidth += $each->length * ($num == 5 ? 40 : 70);
        }

        // debug($flightCompartments);

        $flightContainers = [];

        foreach ($flightCompartments as $i => &$each ) {
            uksort($each,  "self::comparePosition");
            foreach ($each as $item) {
                $flightContainers[] = $item;
            }
        }


        return [$flightContainers, $compartments, $totalWeight, $totalWidth];
    }

    public static function getFlightCompartments($flight, $includeWeight = true){

        $compartments = [];
        $totalWidth = $totalWeight = 0;

        for($i = 5; $i >= 1; $i--) {
            if ($flight->{"cmp_".$i."_wt"}) {

                $weight = $flight->{"cmp_".$i."_wt"};

                $compartments[$i] = new \stdClass();
                $compartments[$i]->length = 3;

                if ($includeWeight){
                    $totalWeight += $weight;
                    $compartments[$i]->weight = $weight;
                }

                if ($i == 5){
                    $compartments[$i]->large_bulk = true;
                }

                $totalWidth += $compartments[$i]->length * ($i == 5 ? 40 : 70);

            }
        }


        return [$compartments, $totalWeight, $totalWidth];
    }

    public static function comparePosition($positionA, $positionB)
    {
        if (preg_match('/(\d+)([LRP]{1})?/', $positionA, $matchA) && preg_match('/(\d+)([LRP]{1})?/', $positionB, $matchB)){

            if (isset($matchA[2]) && isset($matchB[2])) {

                list($txtA, $rowA, $posA) = $matchA;
                list($txtB, $rowB, $posB) = $matchB;

                if ($rowA == $rowB) {
                    if ($posA == PALLET) {
                        return false;
                    }
                    else if ($posB == PALLET){
                        return true;
                    }
                    else if ($posA == RIGHT){
                        return true;
                    }
                    else if ($posB == RIGHT){
                        return false;
                    }
                }
            }
        }

        return strcmp($positionB, $positionA);
    }

    public static function insertContainerToFlight($source, $flightContainerInfo, $containerType, $container, $containerDetails, $airportIDs){
        $flightContainer = null;

        $loadedType = isset($containerDetails['loadedType']) && $containerDetails['loadedType'] ? $containerDetails['loadedType'] : null;

        // Find Flight Container if exists
        if ($flightContainerInfo)
        {
            if ($container)
            {
                $flightContainer = FlightContainer::where("info_id", $flightContainerInfo->id)
                    ->where("container_id", $container->id)
                    ->first();

                // Match
                if (!$flightContainer && $source == UCM && $loadedType){
                    $flightContainer = FlightContainer::where("info_id", $flightContainerInfo->id)
                        ->whereNull("container_matched")
                        ->whereNull("container_id")
                        // Excludes Bulk Positions
                        ->where("row_number", ">=", 10)
                        ->where("row_number", "<", 50)
                        // End
                        ->where("loaded_type", $loadedType)
                        ->first();

                    if (!$flightContainer){
                        $flightContainer = FlightContainer::where("info_id", $flightContainerInfo->id)
                            ->whereNull("container_matched")
                            ->whereNull("container_id")
                            // Excludes Bulk Positions
                            ->where("row_number", ">=", 10)
                            ->where("row_number", "<", 50)
                            // End
                            ->where("loaded_type", "LIKE", "%".$loadedType. "%")
                            ->first();
                    }

                    if ($flightContainer){
                        $flightContainer->container_id = $container->id;
                        $flightContainer->container_matched = true;
                    }
                }
            }
            elseif($containerType)
            {
                $flightContainer = FlightContainer::where("info_id", $flightContainerInfo->id)
                                                    ->where("container_type_id", $containerType->id);

                // Added 23/10/2018 for Flight Com
                if ($containerDetails['rowNumber']){
                    $flightContainer->where("row_number", $containerDetails['rowNumber'])
                                    ->where("position", $containerDetails['position']);
                }

                $flightContainer = $flightContainer->first();
                // End

            }
            elseif ($containerDetails['rowNumber'])
            {
                $flightContainer = FlightContainer::where("info_id", $flightContainerInfo->id)
                    ->where("row_number", $containerDetails['rowNumber'])
                    ->where("position", $containerDetails['position'])
                    ->first();

                if (!$flightContainer && $source == CPM && $loadedType
                        && $containerDetails['rowNumber'] >= 10 && $containerDetails['rowNumber'] < 50)
                {
                    $flightContainer = FlightContainer::where("info_id", $flightContainerInfo->id)
                        ->whereNull("container_matched")
                        ->whereNull("row_number")
                        ->whereNull("position")
                        ->where("loaded_type", $loadedType)
                        ->first();

                    if (!$flightContainer){
                        $flightContainer = FlightContainer::where("info_id", $flightContainerInfo->id)
                            ->whereNull("container_matched")
                            ->whereNull("row_number")
                            ->whereNull("position")
                            ->where("loaded_type", "LIKE", "%".$loadedType. "%")
                            ->first();
                    }

                    if ($flightContainer){
                        $flightContainer->container_matched = true;
                    }
                }
            }

            // Only for manual entries
            if (!$flightContainer && $flightContainerInfo->manual){
                $flightContainer = FlightContainer::where("info_id", $flightContainerInfo->id)
                    ->where("row_number", $containerDetails["rowNumber"])
                    ->where("position", $containerDetails["position"])
                    ->first();

                if ($flightContainer) {
                    if ($container) {
                        $flightContainer->container_id = $container->id;
                    } elseif ($containerType) {
                        $flightContainer->container_type_id = $containerType->id;
                    }
                }
            }
        }

        if (!$flightContainer){

            $flightContainer = new FlightContainer();

            $flightContainer->info_id = $flightContainerInfo->id;
            if ($container){
                $flightContainer->container_id = $container->id;
            }
            elseif ($containerType){
                $flightContainer->container_type_id = $containerType->id;
            }
        }

        // Source
        if ($source == UCM){
            // UCM
            $flightContainer->from_ucm = true;
            if ($loadedType && !$flightContainer->loaded_type){
                $flightContainer->loaded_type = $loadedType;
            }
        }
        elseif ($source == CPM) {
            // CPM
            $flightContainer->from_cpm = true;
            if ($loadedType){
                $flightContainer->loaded_type = $loadedType;
            }
        }
        // Manual Added
        else {
            if ($loadedType){
                $flightContainer->loaded_type = $loadedType;
            }
        }

        if (isset($containerDetails['destinationAirport'])
                && $containerDetails['destinationAirport']
                    && isset($airportIDs[$containerDetails['destinationAirport']]))
        {
            $flightContainer->destination_airport_id = $airportIDs[$containerDetails['destinationAirport']];
        }

        if (isset($containerDetails['rowNumber']) && $containerDetails['rowNumber']) {
            $flightContainer->row_number = $containerDetails['rowNumber'];
        }

        if (isset($containerDetails['position']) && $containerDetails['position']) {
            $flightContainer->position = $containerDetails['position'];
        }

        if (isset($containerDetails['weight']) && $containerDetails['weight']) {
            $flightContainer->weight = $containerDetails['weight'];
        }

        if (isset($containerDetails['vr']) && ($containerDetails['vr'] || $containerDetails['vr'] == 0  || $containerDetails['vr'] == "0" )) {
            $flightContainer->vr = $containerDetails['vr'];
        }

        if (isset($containerDetails['bag_pcs']) && ($containerDetails['bag_pcs'] || $containerDetails['bag_pcs'] == 0  || $containerDetails['bag_pcs'] == "0" )) {
            $flightContainer->bag_pcs = $containerDetails['bag_pcs'];
        }

        if (array_key_exists("notoc_details", $containerDetails)) {
            $flightContainer->notoc_details = $containerDetails['notoc_details'];
        }

        if (array_key_exists("notoc", $containerDetails)) {
            $flightContainer->notoc = $containerDetails['notoc'];
        }

        $flightContainer->save();

        // debug($flightContainer);

        return $flightContainer->id;
    }

}
