<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\Auth;

/**
 * Created by PhpStorm.

 */

class FlightComFlightStaff extends Eloquent{

    protected $table = "flights__com_flights_staff";

    public $timestamps = true;

    protected $guarded = ["id", "created_at", "updated_at"];

    public function flight(){
        return $this->belongsTo("App\\Models\\Flight", "flight_id");
    }

    public function user(){
        return $this->belongsTo("App\\Models\\User", "user_id");
    }

    public function service(){
        return $this->belongsTo("App\\Models\\Service", "service_id");
    }

    public function flightCom(){
        return $this->belongsTo(FlightCom::class, "flight_com_id");
    }

    public function flightComDetails(){
        return $this->belongsTo(FlightComDetails::class, "flight_com_details_id");
    }

    public function createdUser(){
        return $this->belongsTo(User::class, "created_by");
    }

    public static function createFromFlightStaff($flightComDetails, $flightStaff){
        if (!$flightComDetails || !$flightStaff){
            return null;
        }

        // Flight Com Flight Staff
        $fStaff = new FlightComFlightStaff();
        $fStaff->flight_com_id = $flightComDetails->flight_com_id;
        $fStaff->flight_com_details_id = $flightComDetails->id;

        $fStaff->flight_id = $flightStaff->flight_id;
        $fStaff->user_id = $flightStaff->user_id;
        $fStaff->service_id = $flightStaff->service_id;
        $fStaff->service_type = $flightStaff->service_type;

        $fStaff->planned_report_time = $flightStaff->planned_report_time;
        $fStaff->planned_release_time = strtotime($flightStaff->planned_report_time) > strtotime($flightStaff->planned_release_time) ? $flightStaff->planned_report_time : $flightStaff->planned_release_time;

        $fStaff->report_time = $flightStaff->report_time;
        $fStaff->release_time = strtotime($flightStaff->report_time) > strtotime($flightStaff->release_time) ? $flightStaff->report_time : $flightStaff->release_time;

        $fStaff->created_by = $flightStaff->created_by;
        $fStaff->deleted_at = $flightStaff->deleted_at;
        $fStaff->save();

        return $fStaff;
    }
}
