<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

class FlightComDetailsArchive extends Eloquent{

    protected $table = "flights__com_details_archive";

    public $timestamps = true;

    protected $guarded = ["id"];

    public function flightCom(){
        return $this->belongsTo(FlightCom::class, "flight_com_id");
    }

    public function flightStaff(){
        return $this->hasMany(FlightComFlightStaff::class, "flight_com_details_id",  "flight_com_details_id");
    }

    public function checkin(){
        return $this->hasOne(FlightComCheckin::class, "flight_com_details_id",  "flight_com_details_id");
    }

    public function pts(){
        return $this->hasOne(FlightComFlightPTS::class, "flight_com_details_id",  "flight_com_details_id");
    }

    public function ssr(){
        return $this->hasOne(FlightComSSR::class, "flight_com_details_id",  "flight_com_details_id");
    }

    public function pictures(){
        return $this->hasMany(FlightComPicture::class, "flight_com_details_id",  "flight_com_details_id");
    }

    public function containers(){
        return $this->hasMany(FlightComContainer::class, "flight_com_details_id",  "flight_com_details_id");
    }

    public function createdUser(){
        return $this->belongsTo(User::class, "created_by");
    }

    public function user()
    {
        return $this->belongsTo(User::class, "created_by");
    }
}
