<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

class FlightComDetails extends Eloquent{

    protected $table = "flights__com_details";

    public $timestamps = true;

    protected $guarded = ["id", "created_at", "updated_at"];

    public function flightCom(){
        return $this->belongsTo(FlightCom::class, "flight_com_id");
    }

    public function flightStaff(){
        return $this->hasMany(FlightComFlightStaff::class, "flight_com_details_id");
    }

    public function checkin(){
        return $this->hasOne(FlightComCheckin::class, "flight_com_details_id");
    }

    public function pts(){
        return $this->hasOne(FlightComFlightPTS::class, "flight_com_details_id");
    }

    public function ssr(){
        return $this->hasOne(FlightComSSR::class, "flight_com_details_id");
    }

    public function pictures(){
        return $this->hasMany(FlightComPicture::class, "flight_com_details_id");
    }

    public function containers(){
        return $this->hasMany(FlightComContainer::class, "flight_com_details_id");
    }

    public function createdUser(){
        return $this->belongsTo(User::class, "created_by");
    }

    public function user()
    {
        return $this->belongsTo(User::class, "created_by");
    }

    public static function createMessage($flightCom, $authUserID, $message, $enc = null, $ct = null, $iv = null, $s = null){
        $flightComDetails = new FlightComDetails();
        $flightComDetails->flight_com_id = $flightCom->id;
        $flightComDetails->created_by = $authUserID;
        $flightComDetails->message = $message ? $message : null;
        if ($enc){
            $flightComDetails->enc = $enc;
        }
        else if ($ct && $iv && $s){
            $flightComDetails->enc = json_encode(["ct"    => $ct,"iv"    => $iv,"s"     => $s]);
        }
        $flightComDetails->save();

        return $flightComDetails;
    }
}
