<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 25.08.14

 */

class FlightComCheckin extends Eloquent
{
    protected $table = "flights__com_checkin";

    public $timestamps = true;

    protected $guarded = ["id", "created_at", "updated_at"];

    public function flightCom(){
        return $this->belongsTo(FlightCom::class, "flight_com_id");
    }

    public function flightComDetails(){
        return $this->belongsTo(FlightComDetails::class, "flight_com_details_id");
    }

    public function aircraft(){
        return $this->belongsTo(Aircraft::class, "aircraft_id");
    }

    public function createdUser(){
        return $this->belongsTo(User::class, "created_by");
    }

    public static function createRecord($flight, $flightComDetails, $properties){

        $checkIn = new FlightComCheckin();

        $insert = $flightEdited = false;
        foreach ($properties as $index => $value) {
            if($value || $value === "0"){
                $insert = true;
                $checkIn->{$index} = $value;

                if ($flight){
                    if (in_array($index, [
                        "pax_a",
                        "pax_c",
                        "pax_w",
                        "pax_y",
                        "pax_jmp",
                        "pax_adults",
                        "pax_m",
                        "pax_f",
                        "pax_ch",
                        "pax_inf",
                    ]))
                    {
                        $flightEdited = true;
                        $index .= "_actual";
                        $flight->{$index} = $value;
                    }

                    if (in_array($index, [
                        "aircraft_id",
                        "pax_a_booked",
                        "pax_c_booked",
                        "pax_w_booked",
                        "pax_y_booked",

                        "dow",
                        "doi",
                        "mtow",
                        "rtow",

                        "tof",
                        "trip",
                        "eet",
                        "taxi",
                        "block",
                        "altn",
                    ]))
                    {
                        $flightEdited = true;
                        $flight->{$index} = $value;
                    }

                    if (in_array($index, [
                        "capacity_c",
                        "capacity_y",
                    ]))
                    {
                        if (airlineModule() || (ghaModule() && !$flight->ldm)) {
                            $flightEdited = true;
                            $flight->{$index} = $value;
                        }
                    }
                }
            }
        }

        if ($flightEdited){
            $flight->save();
        }

        if ($insert){
            $checkIn->flight_com_id = $flightComDetails->flight_com_id;
            $checkIn->flight_com_details_id = $flightComDetails->id;
            $checkIn->flight_id = $flight->id;
            $checkIn->save();
        }

    }
}
