<?php namespace App\Models; use App\Events\FlightComCreated;
use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

class FlightCom extends Eloquent{

    protected $table = "flights__com";

    public $timestamps = true;

    protected $guarded = ["id", "created_at", "updated_at"];

    public function details(){
        return $this->hasMany(FlightComDetails::class, "flight_com_id");
    }

    public function flight(){
        return $this->belongsTo(Flight::class, "flight_id");
    }

    public function containers(){
        return $this->hasMany(FlightComContainer::class, "flight_com_id");
    }

    public static function createMessageForFlights($flights, $authUserID, $message = null){
        if (!$message || !trim($message)){
            return null;
        }

        $list = [];
        foreach ($flights as $flight) {
            $com = self::getOrCreateFlightCom($flight->id, $authUserID);
            $enc = cryptoJsAesEncrypt($message, PRE_KEY. $com->key.POST_KEY);
            debug(cryptoJsAesDecrypt($enc, PRE_KEY. $com->key.POST_KEY));
            FlightComDetails::createMessage($com, $authUserID, null, $enc);
            $list[] = $com;
        }

        debug($list);

        return $list;
    }

    public static function getOrCreateFlightCom($flightID, $authUserID, $key = null, $broadcast = null){
        if (!$flightID){
            return null;
        }

        $flightCom = FlightCom::where("flight_id", $flightID)
            ->first();


        if (!$flightCom){
            $flightCom = new FlightCom();
            $flightCom->created_by = $authUserID;
            $flightCom->flight_id = $flightID;
            $flightCom->key = $key ? $key : generateRandomPassword(10);
            $flightCom->save();

            if ($broadcast){
                // Broadcast
                broadcast(new FlightComCreated($flightCom, true))->toOthers();
            }
        }

        return $flightCom;
    }
}
