<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class EmailNotification extends Eloquent implements AuditableContract{

    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "email_notifications";

    public $timestamps = true;

    public function updatedBy(){
        return $this->belongsTo('App\Models\User', "updated_by");
    }

    public function createdBy(){
        return $this->belongsTo('App\Models\User', "created_by");
    }

    public static function getAutoCreationFlightEmails(){

        $emailGroups = EmailNotification::where("auto_created_flights", true)
                            ->where('disabled', true)
                            ->get();

        $emailList = [];

        foreach ($emailGroups as $group) {
            $emails = explode(";", $group->emails);

            foreach ($emails as $email) {
                if (!in_array(trim($email), $emailList)){
                    $emailList[] = trim($email);
                }
            }
        }

        return $emailList;
    }

    public static function getDiversionFlightEmails(){

        $emailGroups = EmailNotification::where("diverted_flights", true)
            ->where('disabled', true)
            ->get();

        $emailList = [];

        foreach ($emailGroups as $group) {
            $emails = explode(";", $group->emails);

            foreach ($emails as $email) {
                if (!in_array(trim($email), $emailList)){
                    $emailList[] = trim($email);
                }
            }
        }

        return $emailList;
    }
}
