<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 12.08.14

 */
use Illuminate\Database\Eloquent\SoftDeletes;

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class Department extends Eloquent implements AuditableContract
{
    use SoftDeletes, Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "structure__departments";

    public $timestamps = TRUE;

    protected $softDelete = TRUE;

    protected $dates = ["deleted_at"];

    protected $guarded = [
        "id",
        "created_at",
        "deleted_at"
    ];

    public function resources()
    {
        return $this->belongsToMany("App\\Models\\Resource", "departments_resources")->withTimestamps();
    }

    public function users()
    {
        return $this->belongsToMany("App\\Models\\User", "users__departments", "department_id")->withTimestamps();
    }

    public function subDepartment()
    {
        return $this->hasMany("App\\Models\\SubDepartment", "department_id");
    }

    public function position()
    {
        return $this->hasMany("App\\Models\\Position", "department_id");
    }

    public function module()
    {
        return $this->hasMany("App\\Models\\Module", "department_id");
    }

    public static function listDepartments(){
        return Department::pluck("name", "id")->all();
    }

    public static function getOrCreateDepartment($name){

        $department = Department::where('name', $name)
                                ->orWhere("name", ucwords(strtolower($name)))
                                ->first();

        if (!$department){
            $department = new Department();
        }

        $department->name = ucwords($name);
        $department->lang = createLangString(ucwords($name)) ;
        $department->save();

        return $department;
    }

}
