<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\DB;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 25.08.14

 */

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class Delay extends Eloquent implements AuditableContract
{
    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "delays";

    public $timestamps = true;

    public function airline(){
        return $this->belongsTo('App\Models\Airline', 'airline_id');
    }

    public function group(){
        return $this->belongsTo('App\Models\DelayGroup', 'delay_group_id');
    }

    public function emailNotification(){
        return $this->belongsTo('App\Models\EmailNotification', 'email_notification_id');
    }

    public static function GetDelayWithAirlineList(){

        $delays = Delay::with(["airline"])
                    ->whereNull("deleted_at")
                    ->orderBy("airline_id")
                    ->orderBy("code")
                    ->get();

        $result = [];
        foreach($delays as $each){
            if ($each->airline){
                $result[$each->id] = $each->airline->iata."-".$each->code;
            }
            else {
                $result[$each->id] = $each->code;
            }
        }

        return ["" => "Select Delay Code"] + $result;
    }

    public static function createUpdate($data){
        $airline = $data['airline'];
        $code = isset($data['code']) ? $data['code'] : null;
        $alpha = isset($data['alpha_code']) ? $data['alpha_code'] : null;

        $delay = Delay::where("airline_id", $airline)
                        ->whereNull("deleted_at");

        if ($alpha && $code){
            $delay->where(function($sql) use ($code, $alpha){
                $sql->where("code", $code)
                    ->orWhere("alpha_code", $alpha);
            });
        }
        else if ($code){
            $delay->where("code", $code);
        }
        else if ($alpha){
            $delay->where("alpha_code", $alpha);
        }

        $delay = $delay->first();

        if (!$delay){
            $delay = new Delay();
            $delay->airline_id = $airline;
            $delay->code = $code;
            $delay->alpha_code = $alpha;
        }

        if (isset($data['group']) && $data['group']){
            $group = DelayGroup::where("name", $data['group'])
                                ->first();

            if (!$group){
                $group = new DelayGroup();
                $group->name = $data['group'];
            }

            if (isset($data['group_ln']) && $data['group_ln']){
                $group->name_ln = $data['group_ln'];
            }

            $group->save();

            $delay->delay_group_id = $group->id;
        }

        if (isset($data['alpha_code']) && $data['alpha_code']){
            $delay->alpha_code = $data['alpha_code'];
        }

        if (isset($data['description']) && $data['description']){
            $delay->description = $data['description'];
        }

        if (isset($data['explanation']) && $data['explanation']){
            $delay->explanation = $data['explanation'];
        }

        // new fields
        if (isset($data['description_ln']) && $data['description_ln']){
            $delay->description_ln = $data['description_ln'];
        }

        if (isset($data['explanation_ln']) && $data['explanation_ln']){
            $delay->explanation_ln = $data['explanation_ln'];
        }

        $delay->save();
    }
}
