<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 25.08.14

 */

class CurrencyRate extends Eloquent
{
    protected $table = "currency__rates";
    public $timestamps = true;

    protected $fillable = ['date', 'from_currency_id', 'rate', 'to_currency_id'];


    /**
     * First Or Create And Then Update Rate Value
     * @param $fromCurrencyId
     * @param $toCurrencyId
     * @param $date
     * @param $rate
     */
    public static function firstOrCreateWithRate($fromCurrencyId, $toCurrencyId, $date, $rate){
        $currencyRate = CurrencyRate::firstOrCreate([
            'from_currency_id'  => $fromCurrencyId,
            'date'              => date('Y-m-d', strtotime($date)),
            'to_currency_id'    => $toCurrencyId,
        ]);
        $currencyRate->rate =  $rate;
        $currencyRate->save();
    }

    /**
     * Calculate Inverse Rate
     * @param $fromCurrencyId
     * @param $toCurrencyId
     * @param $date
     * @param $rate
     */
    public static function convertInverse($fromCurrencyId, $toCurrencyId, $date, $rate){
        $currencyRate = CurrencyRate::firstOrCreate([
            'from_currency_id'  => $toCurrencyId,
            'date'              => date('Y-m-d', strtotime($date)),
            'to_currency_id'    => $fromCurrencyId,
        ]);
        $currencyRate->rate =  1 / $rate;
        $currencyRate->save();
    }
}
