<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

class CrewRosterDetail extends Eloquent{

    protected $table = "crew__rosters_details";

    public $timestamps = true;

    protected $fillable = [
        "crew_roster_id",
        "flight_id",
        "user_id",
        "position_id",
        "position_order",
        "is_standby",
        "is_dhc",
        'created_at',
        'created_by',
        'updated_at',
        'updated_by'
    ];

    public function crewRoster(){
        return $this->belongsTo('App\Models\CrewRoster', 'crew_roster_id');
    }

    public function flight(){
        return $this->belongsTo('App\Models\Flight', 'flight_id');
    }

    public function user(){
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function position(){
        return $this->belongsTo('App\Models\Position', 'position_id');
    }
}
