<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\DB;

/**
 * Created by PhpStorm.

 */

class CrewRestrictionRoute extends Eloquent{

    protected $table = "crew__restrictions__route";

    public $timestamps = true;

    public $fillable = [
        'user_id',
        'flight_route_id'
    ];

    public static function listRoutes($userId = null){
        $result = self::select(DB::raw('CONCAT(s_fromAirport.iata, "-", s_toAirport.iata) AS route'), "flight_route_id as id")
            ->join('flights__routes', 'crew__restrictions__route.flight_route_id', '=','flights__routes.id')
            ->join('airports as fromAirport', 'flights__routes.from_airport_id', '=','fromAirport.id')
            ->join('airports as toAirport', 'flights__routes.to_airport_id', '=','toAirport.id');

        if ($userId){
            if (is_array($userId)){
                $result->whereIn("user_id", $userId);
            }
            else {
                $result->where("user_id", $userId);
            }
        }

        return $result->pluck('route', 'id')->all();
    }
}
