<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\DB;

/**
 * Created by PhpStorm.

 */

class CrewRestrictionPairing extends Eloquent{

    protected $table = "crew__restrictions__pairing";

    public $timestamps = true;

    public $fillable = [
        'user_id',
        'pair_user_id'
    ];

    public static function listPairs($userId = null){

        $result = self::select(DB::raw("CONCAT(first_name,' ',last_name) AS full_name, pair_user_id as id"))
            ->join('users', 'crew__restrictions__pairing.pair_user_id', '=','users.id');

        if ($userId){
            if (is_array($userId)){
                $result->whereIn("user_id", $userId);
            }
            else {
                $result->where("user_id", $userId);
            }
        }

        return $result->pluck('full_name', 'id')->all();
    }
}
