<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

class CrewRestrictionAircraftType extends Eloquent{

    protected $table = "crew__restrictions__aircraft_type";

    public $timestamps = true;

    public $fillable = [
        'user_id',
        'aircraft_type_id'
    ];

    public static function listAircraftTypes($userId = null){

        $result = self::select('aircraft__types.name as name', "aircraft__types.id as id")
            ->join('aircraft__types', 'crew__restrictions__aircraft_type.aircraft_type_id', '=','aircraft__types.id');


        if ($userId){
            if (is_array($userId)){
                $result->whereIn("user_id", $userId);
            }
            else {
                $result->where("user_id", $userId);
            }
        }

        return $result->pluck('name', 'id')->all();
    }
}
