<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 25.08.14

 */

class Country extends Eloquent
{
    protected $table = "countries";

    protected $fillable = ['country', 'abbr'];

    public $timestamps = true;
        public static function getCountriesWithRegion()
        {
            $data = Country::get(array('region_id','country','id'))->toArray();
            return $data;
        }

    public static function getCountries(){
       /* $data = Country::select( ["country"])
            /*->whereRaw('country != 0 AND country != ""')
            //->orderBy('country')
            ->get();*/


       // $data = DB::table('countries')->pluck('country');
        $data = Country::pluck('country','id')->all();
        // debug($data);
        return $data;
    }
    public  static  function  getCountryName($country_id){
        $country_name = Country::find($country_id)->country;
        return $country_name;
    }

    public function city()
    {
        return $this->hasMany("App\\Models\\City");
    }

    public function cityLimit()
    {
        return self::city()->where('population', '>', 500000)
            ->orderBy('population', 'DESC')
            ->limit(100);


    }

}
