<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

class ContainerType extends Eloquent{

    protected $table = "containers__types";

    public $timestamps = true;

    public static function findByName($containerDetails){
        $containerType = null;

        if (isset($containerDetails["containerTypeName"]) && $containerDetails["containerTypeName"]){
            $containerType = ContainerType::where("name", strtoupper($containerDetails["containerTypeName"]))
                ->first();

            if (!$containerType){
                $containerType = new ContainerType();
                $containerType->name = strtoupper($containerDetails["containerTypeName"]);
                $containerType->save();
            }
        }

        return $containerType;
    }
}
