<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

class Container extends Eloquent{

    protected $table = "containers";

    public $timestamps = true;

    public function type()
    {
        return $this->belongsTo("App\\Models\\ContainerType", "container_type_id");
    }

    public function airline()
    {
        return $this->belongsTo(Airline::class, "airline_id");
    }

    public static function find($containerType, $containerDetails, $airline, $airlineIDs, $airlineICAOIDs){
        $airlineId = $container = null;

        $owner = isset($containerDetails["owner"]) && $containerDetails["owner"] ?
                        strtoupper($containerDetails["owner"]) : null;

        if ($owner) {
            if (strlen($owner) == 3 && isset($airlineICAOIDs[$owner])) {
                $airlineId = $airlineICAOIDs[$owner];
            }
            else if (strlen($owner) == 2 && isset($airlineIDs[$owner])) {
                $airlineId = $airlineIDs[$owner];
            }
        }

        if (!$airlineId && $airline){
            $airlineId = $airline->id;
        }

        if (isset($containerDetails["containerNumber"]) && $containerDetails["containerNumber"]){

            $container = Container::where("num", $containerDetails["containerNumber"])
                                    ->where("airline_id", $airlineId);

            if ($owner) {
                $container->where("owner", $owner);
            }

            $container = $container->first();

            if (!$container){
                $container = new Container();
                $container->num = $containerDetails["containerNumber"];
            }

            $container->airline_id          = $airlineId;
            $container->owner               = $owner;
            $container->container_type_id   = $containerType ? $containerType->id   : null;
            $container->save();
        }

        return $container;
    }

}
