<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */

class City extends Eloquent {
    protected $table = "cities";
    protected $guarded = [
        "id",
        "created_at",
        "updated_at"
    ];
    public $timestamps = TRUE;


    public function country()
    {
        return $this->belongsTo("App\\Models\\Country");
    }

    public function hub()
    {
        return $this->hasMany("Hub");
    }

    public static function listByCountries($countryIDs = null){
        $result = City::select([
            "id",
            "country_id",
            "city",
        ]);

        if ($countryIDs){
            if (is_array($countryIDs) && count($countryIDs)){
                $result->whereIn("country_id", $countryIDs);
            }
            else{
                $result->where("country_id", $countryIDs);
            }
        }

        return $result->orderBy("country_id")
            ->orderBy("city")
            ->pluck("city", "id")
            ->all();
    }

    public static function getCitiesByCountry($countryIDs = null){

        $result = City::select([
            "id",
            "country_id",
            "city",
        ]);

        if ($countryIDs){
            if (is_array($countryIDs) && count($countryIDs)){
                $result->whereIn("country_id", $countryIDs);
            }
            else{
                $result->where("country_id", $countryIDs);
            }
        }

        $result = $result->groupBy("country_id", "id", "city")
                        ->orderBy("country_id")
                        ->orderBy("city")
                        ->get();

        $list = [];
        foreach ($result as $each) {
            if (!isset($each->country_id)){
                $list[$each->country_id] = [];
            }

            $list[$each->country_id][] = [
                "id"    => $each->id,
                "city"  => $each->city,
            ];
        }


        return $list;
    }
}
