<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */

use App\Http\Controllers\ReportController;

class Chart extends Eloquent {
    protected $table = "charts";
    public $timestamps = true;


    public function chartType(){
        return $this->belongsTo('App\Models\ChartType', 'chart_type_id');
    }

    public static function worldBankApiCharts($data, $iteration = FALSE, $type = 'Single'){

        $counter = 0;

        $colors = [
            '#00d2ff',
            '#ff7200',
            '#c3eb00',
            '#f64040',
            '#06fc2e',
            '#fe41d4',

            '#d7d7d7',
            '#001eff',
            '#ffda0d',
            '#dc2659',
            '#4eff80',
            '#720059',
        ];

        switch($type){
            case 'ChartJS-Multiple';

                $graph = [
                    'year'  => $data[0]->country->value,
                    'date'  => [],
                    'value' => []
                ];

                foreach ($data as $j => $each) {
                    //$color = $colors[$counter];
                    $value = $each->value < 10 ? round($each->value, 2) : round($each->value);
                    $graph["date"][] = $each->date;
                    $graph["value"][] = $value;
                    //$counter++;
                }

                $graph["date"] = array_reverse($graph["date"]);
                $graph["value"] = array_reverse($graph["value"]);

                break;

            case 'ChartJS-Single':
                $graph[] = ['Date/Period', 'Value', ['role' => 'style']];
                $graph = [
                    'date'  => [],
                    'value' => [],
                    'color' => [],
                ];

                foreach ($data as $j => $each) {
                    $graph["date"][] = $each->date;
                    $graph["value"][] = round($each->value);
                    $graph["color"][] = $iteration ? $colors[$iteration] : $colors[$counter];
                    //$counter++;
                }

                $graph["date"] = array_reverse($graph["date"]);
                $graph["value"] = array_reverse($graph["value"]);
                $graph["color"] = array_reverse($graph["color"]);

                break;

            case 'Multiple';

                $graph[] = ['Year', "{$data[0]->country->value}"];

                foreach ($data as $j => $each) {
                    //$color = $colors[$counter];
                    $value = $each->value < 10 ? round($each->value, 2) : round($each->value);
                    $graphData[] = ["{$each->date}", $value];
                    //$counter++;
                }

                $graph = array_merge($graph, array_reverse($graphData));
                break;

            case 'Single':
            default:
                $graph[] = ['Date/Period', 'Value', ['role' => 'style']];
                foreach ($data as $j => $each) {
                    $color = $iteration ? $colors[$iteration] : $colors[$counter];
                    $graphData[] = ["{$each->date}", round($each->value), "{$color}"];
                    //$counter++;
                }
                $graph = array_merge($graph, array_reverse($graphData));
                break;
        }

        return $graph;
    }


    /**
     * Get Chart Data By Constant (Filter: Date (From, To)
     * @param $chartName
     * @param bool $report_period_id
     * @param bool $date_from
     * @param bool $label
     * @param bool $date_to
     * @param bool $group
     * @param bool $revenue_type
     * @return array
     */
    public static function getChartByName($chartName, $report_period_id = FALSE, $date_from = FALSE, $date_to = FALSE, $revenue_type = FALSE, $label = FALSE, $group = FALSE){
        $yesterday = date('Y-m-d', strtotime('-1 days'));
        //$yesterday = '2015-07-13';
        $yesterdayLastYear = date('Y-m-d', strtotime('-1 years', strtotime($yesterday)));

        // Get Period For Revenue Charts
        $revenuePeriod = revenueGetPeriod($revenue_type, $report_period_id, $date_from, $date_to);

        if ($date_from && $date_to) {
            $dates = [$date_from, $date_to];
        }
        else {
            $dates = [$yesterday, $yesterdayLastYear];
        }
        debug($date_from);

        $graph = [];
        $counter = 0;
        $colors = [
            '#00d2ff', '#ff7200', '#c3eb00', '#f64040', '#06fc2e', '#fe41d4',
            '#d7d7d7', '#001eff', '#ffda0d', '#dc2659', '#4eff80', '#720059',
            '#00d2ff', '#ff7200', '#c3eb00', '#f64040', '#06fc2e', '#fe41d4',
            '#d7d7d7', '#001eff', '#ffda0d', '#dc2659', '#4eff80', '#720059',
            '#00d2ff', '#ff7200', '#c3eb00', '#f64040', '#06fc2e', '#fe41d4',
            '#d7d7d7', '#001eff', '#ffda0d', '#dc2659', '#4eff80', '#720059',
            '#00d2ff', '#ff7200', '#c3eb00', '#f64040', '#06fc2e', '#fe41d4',
            '#d7d7d7', '#001eff', '#ffda0d', '#dc2659', '#4eff80', '#720059',
            '#00d2ff', '#ff7200', '#c3eb00', '#f64040', '#06fc2e', '#fe41d4',
            '#d7d7d7', '#001eff', '#ffda0d', '#dc2659', '#4eff80', '#720059',
            '#00d2ff', '#ff7200', '#c3eb00', '#f64040', '#06fc2e', '#fe41d4',
            '#d7d7d7', '#001eff', '#ffda0d', '#dc2659', '#4eff80', '#720059',
        ];

        switch ($chartName){
            case CHART_SEAT_FACTORS:
                $final_data = ReportController::seatFactorsArray($date_from, $date_to, $label, 5);
                $graph[] = ['Date/Period', 'Percentage, %', ['role' => 'style']];
                foreach ($final_data as $date => $each) {
                    $graph[] = ["$date", round($each->sf), "$colors[$counter]"];
                    $counter++;
                }
                return $graph;

            case CHART_PUNCTUALITY:
                $counter = 0;

                $final_data = ReportController::punctualityArray($date_from, $date_to, true);
                $final_category = $final_data[0];
                $categories = $final_data[1];
                $graph[] = ['Category', 'Percentage, %', ['role' => 'style'] ];
                foreach ($final_category as $index=>$each) {
                    $graph[] = ["$categories[$index]",$each->percentage,"$colors[$counter]"];
                    $counter++;
                }

                return $graph;

            case CHART_FLIGHT_COUNTER:
                $counter = 0;

                $final_data = Flight::getFlightCounter($dates);
                $graph[] = ['Date', 'Count', ['role' => 'style']];
                $itemCounter = 0;
                foreach ($final_data as $item) {
                    if (!is_null($item)) {
                        if ($group){
                            $itemCounter += $item->counter;
                        }
                        else {
                            $date_format = date('d M y', strtotime($item->date));
                            $graph[] = ["$date_format", $item->counter, "$colors[$counter]"];
                            $counter++;
                        }
                    }
                }
                if ($group){
                    $graph[] = [$label, $itemCounter, "$colors[2]"];
                }
                return $graph;

            case CHART_PAX_COUNTER_AND_BOUND:
                if ($date_from && $date_to){
                    $dates = [$date_from, $date_to];
                }
                else{
                    $dates = $yesterday;
                }
                $counter2 = 0;
                $final_data = Flight::getPaxCounter($dates,'outbound');
                $graph_bound[] = ['Bound','PAX', ['role' => 'style']];
                $outbound_pax = 0;

                foreach ($final_data as $item) {
                    if (!is_null($item)) {
                        $outbound_pax = (int)$item->pax_c + (int)$item->pax_y;
                        $graph_bound[] = ["Outbound", $outbound_pax, $colors[$counter2++]];
                    }
                }

                $counter = 0;
                $final_data = Flight::getPaxCounter($dates);
                $graph[] = ['Cabin','PAX', ['role' => 'style']];
                foreach ($final_data as $item) {
                    if (!is_null($item)) {
                        $graph[] = ["Business", (int)$item->pax_c, $colors[$counter++]];
                        $graph[] = ["Economy",  (int)$item->pax_y, $colors[$counter++]];

                        $inbound_pax = (int)$item->pax_c + (int)$item->pax_y - $outbound_pax;
                        $graph_bound[] = ["Inbound", $inbound_pax, $colors[$counter2++]];

                    }
                }
                return [$graph, $graph_bound];
            case CHART_PAX_BOUND:
                if ($date_from && $date_to){
                    $dates = [$date_from, $date_to];
                }
                else{
                    $dates = "2015-07-08";
                }
                $counter2 = 0;
                $final_data = Flight::getPaxCounter($dates,'outbound');
                $graph_bound[] = ['Bound','PAX', ['role' => 'style']];
                $outbound_pax = 0;

                foreach ($final_data as $item) {
                    if (!is_null($item)) {
                        $outbound_pax = (int)$item->pax_c + (int)$item->pax_y;
                        $graph_bound[] = ["Outbound", $outbound_pax, $colors[$counter2++]];
                    }
                }

                $final_data = Flight::getPaxCounter($dates);
                foreach ($final_data as $item) {
                    if (!is_null($item)) {
                        $inbound_pax = (int)$item->pax_c + (int)$item->pax_y - $outbound_pax;
                        $graph_bound[] = ["Inbound", $inbound_pax, $colors[$counter2++]];
                    }
                }
                return $graph_bound;
            case CHART_PAX_CABIN:

                $final_data = Flight::getPaxCounter($dates);
                $graph[] = ['Cabin','PAX', ['role' => 'style']];
                foreach ($final_data as $item) {
                    if (!is_null($item)) {
                        $graph[] = ["Business", (int)$item->pax_c, $colors[$counter++]];
                        $graph[] = ["Economy",  (int)$item->pax_y, $colors[$counter++]];
                    }
                }
                return $graph;

            case 'RevenueYesterdayByFlights':
                $graph[] = ['Date/Period', 'Revenue', ['role' => 'style']];
                $final_data = PassengerFlight::getFlightPaxRevenueWidget($yesterday,$yesterday,6,null,null,'departure_date');
                foreach($final_data as $each){
                    $graph[] = "['".$each['date']."',".$each['pax'].",".round(($each['revenue'])/1000,1)."], ";
                }
                return $graph[0];

            case 'PaxRevenueYesterdayFlown':
                $final_data = PassengerFlight::getFlightPaxRevenueWidget($yesterday,$yesterdayLastYear,5,null,'compare','departure_date');
                foreach($final_data as $i=>$each){
                    $color = $colors[$counter++];
                    $graph[] = ["$each->date", (int)$each->pax, round(($each->revenue)/1000,1), "$color" ];
                }

                return $graph;

            case 'PaxRevenueYesterdaySold':
                $final_data = PassengerFlight::getFlightPaxRevenueWidget($yesterday, $yesterdayLastYear,5,null,'compare', 'sales_date');
                foreach($final_data as $each){
                    $color = $colors[$counter++];
                    $graph[] = ["$each->date", (int)$each->pax, round(($each->revenue)/1000,1), "$color" ];
                }
                return $graph;

            case CHART_REVENUE_SALES_CHANNELS:
                $counter = 0;
                debug($revenuePeriod);
                $final_data = PassengerFlight::getRevenue($revenuePeriod, ['field' => 'channel']);
                $graph[] = ['Channel', 'Revenue', ['role' => 'style']];
                foreach ($final_data as $i => $each) {
                    $counter = $counter % 12;
                    $graph[] = ["{$each->grouped_field}", round($each->revenue), "{$colors[$counter++]}"];
                }
                return $graph;

            case CHART_REVENUE_TOP_SECTORS:
                $graph[] = ['Sector', 'Revenue', ['role' => 'style']];
                $final_data = PassengerFlight::getTopSectors($revenuePeriod);
                foreach($final_data as $i=>$each){
                    $sector = $each->departure_airport."-".$each->arrival_airport;
                    $color = $colors[$counter++];
                    $graph[] = [$sector, round((int)$each->revenue), "$color"];
                }
                return $graph;

            case CHART_REVENUE_BY_COUNTRY:
                $final_data = PassengerOrder::revenueByCountry($yesterday, false, REVENUE_FLOWN);
                $graph = [
                    0 => [
                        'abbr'      => '',
                        'country'   => 'POS',
                        'pax'       => 'PAX',
                        'revenue'   => 'Revenue',
                        'yield'     => 'Yield',
                        'share'     => 'Share,%'
                    ]
                ];

                $totalRevenue = 0;
                array_walk($final_data, function($each) use (&$totalRevenue){
                    array_walk($each, function($item) use (&$totalRevenue){
                        $totalRevenue += $item->revenue;
                    });
                });


                foreach ($final_data as $i => $each) {
                    $yield = round($each->revenue / $each->pax);
                    $graph[] = [
                        'abbr'      => "$each->abbr",
                        'country'   => "$each->country",
                        'revenue'   => round((int)$each->revenue),
                        'pax'       => $each->pax,
                        'yield'     => $yield,
                        'share'     => 100 * round($each->revenue / $totalRevenue, 3)
                    ];
                }
                return $graph;

            case CHART_PAX_REVENUE:
                $counter = 0;
                // Yesterday
                $date[0] = date('y-m-d', strtotime('2015-07-13')); //date('y-m-d', strtotime('-1 days'));
                // Yesterday, Last Year
                $date[1] = date('y-m-d', strtotime("- 1 years", strtotime($date[0])));

                $final_data = PassengerFlight::getFlightPaxRevenueWidget($date[0],$date[1], null,null,'compare','departure_date');

                $graphs =[ 0 => [ ['Date/Period', 'Revenue', ['role' => 'style']] ],  1 => [ ['Date/Period', 'PAX', ['role' => 'style']] ] ];
                $types = ['Flown', 'Sold'];

                foreach ($types as $type) {
                    foreach ($graphs as $i=>$graph){
                        foreach ($date as $each){
                            $date_format = date('d M y', strtotime($each));
                            $graphs[$i]["$type, $date_format"] = ["$type, $date_format", 0, "#ffffff" ];
                        }
                    }
                }

                foreach($final_data as $i=>$each){
                    $color = $colors[$counter++];
                    $date_format = date('d M y', strtotime($each->date));
                    $graphs[0]["Flown, $date_format"] = ["Flown, $date_format", round($each->revenue), "$color" ];
                    $graphs[1]["Flown, $date_format"] = ["Flown, $date_format", (int)$each->pax, "$color" ];
                }


                $final_data = PassengerFlight::getFlightPaxRevenueWidget($date[0],$date[1], null,null,'compare', 'sales_date');

                foreach($final_data as $each){
                    $color = $colors[$counter++];
                    $date_format = date('d M y', strtotime($each->date));
                    $graphs[0]["Sold, $date_format"] = ["Sold, $date_format", round($each->revenue), "$color" ];
                    $graphs[1]["Sold, $date_format"] = ["Sold, $date_format", (int)$each->pax, "$color" ];
                }
                if (count($final_data) < 2){

                }
                $graphs[0] = array_values($graphs[0]);
                $graphs[1] = array_values($graphs[1]);
                return $graphs;


            case CHART_PAX_DIRECTIONAL:
                $graphs = [['Date/Period', 'PAX']];
                if ($date_from && $date_to){
                    if ($revenue_type == REVENUE_FLOWN) {
                        $final_data = PassengerFlight::getRevenue($revenuePeriod, ['field' => 'departure_date']);
                    }
                    else {
                        $final_data = PassengerFlight::getRevenue($revenuePeriod, ['field' => 'sales_date']);
                    }

                    $paxGroup = 0;
                    foreach ($final_data as $each) {
                        if ($group){
                            $paxGroup += $each->pax;
                        }
                        else {
                            $graphs[] = [ucfirst($revenue_type) . ", " . $each->grouped_field, round($each->pax)];
                        }
                    }
                    if ($group){
                        $graphs[] = [ucfirst($revenue_type), round($paxGroup)];
                    }
                }
                return $graphs;

            case CHART_PAX:
                $counter = 0;

                if ($date_from && $date_to){
                    if ($revenue_type == REVENUE_FLOWN) {
                        $final_data = PassengerFlight::getRevenue($revenuePeriod, ['field' => 'departure_date']);
                    }
                    else {
                        $final_data = PassengerFlight::getRevenue($revenuePeriod, ['field' => 'sales_date']);
                    }
                    $graphs = [['Date/Period', 'PAX']];
                    $paxGroup = 0;
                    foreach ($final_data as $each) {
                        if ($group){
                            $paxGroup += $each->pax;
                        }
                        else {
                            $graphs[] = [ucfirst($revenue_type) . ", " . $each->grouped_field, round($each->pax)];
                        }
                    }
                    if ($group){
                        $graphs[] = [ucfirst($revenue_type), round($paxGroup)];
                    }
                }
                else {

                    // Yesterday
                    $date[0] = date('y-m-d', strtotime('-1 days')); //date('y-m-d', strtotime('2015-07-13')); //
                    // Yesterday, Last Year
                    $date[1] = date('y-m-d', strtotime("- 1 years", strtotime($date[0])));

                    $final_data = PassengerFlight::getFlightPaxRevenueWidget($date[0], $date[1], null, null, 'compare', 'departure_date');

                    $graphs = [['Date/Period', 'PAX', ['role' => 'style']]];
                    $types = ['Flown', 'Sold'];

                    foreach ($types as $type) {
                        foreach ($date as $each) {
                            $date_format = date('d M y', strtotime($each));
                            $graphs["$type, $date_format"] = ["$type, $date_format", 0, "#ffffff"];
                        }
                    }

                    foreach ($final_data as $i => $each) {
                        $color = $colors[$counter++];
                        $date_format = date('d M y', strtotime($each->date));
                        $graphs["Flown, $date_format"] = ["Flown, $date_format", (int)$each->pax, "$color"];
                    }


                    $final_data = PassengerFlight::getFlightPaxRevenueWidget($date[0], $date[1], null, null, 'compare', 'sales_date');

                    foreach ($final_data as $each) {
                        $color = $colors[$counter++];
                        $date_format = date('d M y', strtotime($each->date));
                        $graphs["Sold, $date_format"] = ["Sold, $date_format", (int)$each->pax, "$color"];
                    }
                    if (count($final_data) < 2) {

                    }
                    $graphs = array_values($graphs);
                }
                return $graphs;

            case CHART_REVENUE:
                $counter = 0;
                // Yesterday
                $date[0] = date('y-m-d', strtotime('-1 days')); //date('y-m-d', strtotime('2015-07-13')); //
                // Yesterday, Last Year
                $date[1] = date('y-m-d', strtotime("- 1 years", strtotime($date[0])));

                $compare = true;
                if ($date_from && $date_to){
                    if ($revenue_type == REVENUE_FLOWN) {
                        $final_data = PassengerFlight::getRevenue($revenuePeriod, ['field' => 'departure_date']);
                    }
                    else {
                        $final_data = PassengerFlight::getRevenue($revenuePeriod, ['field' => 'sales_date']);
                    }
                    $graphs = [['Date/Period', 'Revenue']];
                    $revenueGroup = 0;
                    foreach ($final_data as $each) {
                        if ($group){
                            $revenueGroup += $each->revenue;
                        }
                        else {
                            $graphs[] = [ucfirst($revenue_type) . ", " . $each->grouped_field, round($each->revenue)];
                        }
                    }
                    if ($group){
                        $graphs[] = [ucfirst($revenue_type), round($revenueGroup)];
                    }
                }
                else {
                    $final_data = PassengerFlight::getFlightPaxRevenueWidget($date[0], $date[1], null, null, $compare, 'departure_date');
                    $graphs = [['Date/Period', 'Revenue', ['role' => 'style']]];
                    $types = ['Flown', 'Sold'];

                    foreach ($types as $type) {
                        foreach ($date as $each) {
                            $date_format = date('d M y', strtotime($each));
                            $graphs["$type, $date_format"] = ["$type, $date_format", 0, "#ffffff"];
                        }
                    }

                    foreach ($final_data as $i => $each) {
                        $color = $colors[$counter++];
                        $date_format = date('d M y', strtotime($each->date));
                        $graphs["Flown, $date_format"] = ["Flown, $date_format", round($each->revenue), "$color"];
                    }

                    $final_data = PassengerFlight::getFlightPaxRevenueWidget($date[0], $date[1], null, null, 'compare', 'sales_date');

                    foreach ($final_data as $each) {
                        $color = $colors[$counter++];
                        $date_format = date('d M y', strtotime($each->date));
                        $graphs["Sold, $date_format"] = ["Sold, $date_format", round($each->revenue), "$color"];
                    }

                    $graphs = array_values($graphs);
                }
                return $graphs;
        }
    }

    public static function getChartJSByName($chartName, $report_period_id = FALSE, $date_from = FALSE, $date_to = FALSE, $revenue_type = FALSE, $label = FALSE, $group = FALSE){
        $yesterday = date('Y-m-d', strtotime('-1 days'));
        //$yesterday = '2015-07-13';
        $yesterdayLastYear = date('Y-m-d', strtotime('-1 years', strtotime($yesterday)));


        // Get Period For Revenue Charts
        $revenuePeriod = revenueGetPeriod($revenue_type, $report_period_id, $date_from, $date_to);

        if ($date_from && $date_to) {
            $dates = [$date_from, $date_to];
        }
        else {
            $dates = [$yesterday, $yesterdayLastYear];
        }

        switch ($chartName){
            case CHART_SEAT_FACTORS:
                $final_data = ReportController::seatFactorsArray($date_from, $date_to, $label, 5);
                $graph = [
                    'Date/Period'   => [],
                    'Percentage, %' => []
                ];

                foreach ($final_data as $date => $each) {
                    $graph["Date/Period"][] = $date;
                    $graph["Percentage, %"][] = round($each->sf);
                }

                return $graph;

            case CHART_SEAT_FACTORS_DAILY:

                $graph = [
                    'Date/Period'   => [],
                    'Percentage, %' => []
                ];

                $graph = [];

                $k = 0;
                for ($i = strtotime($date_from); $i < strtotime($date_to); $i += (60*60*24)){
                    $date = date("Y-m-d", $i);
                    $final_data = ReportController::seatFactorsArray($date, $date, $label, 5);

                    foreach ($final_data as $j => $each) {
                        $graph[] = [$k++, round($each->sf)];
//                        $graph["Date/Period"][] = $date;
//                        $graph["Percentage, %"][] = round($each->sf);
                    }
                }

                return $graph;

            case CHART_PUNCTUALITY:
                $final_data = ReportController::punctualityArray($date_from, $date_to, true);
                $final_category = $final_data[0];
                $categories = $final_data[1];

                $graph = [
                    'Category'   => [],
                    'Percentage, %' => []
                ];

                foreach ($final_category as $index=>$each) {
                    $graph["Category"][] = $categories[$index];
                    $graph["Percentage, %"][] = $each->percentage;
                }

                return $graph;

            case CHART_FLIGHT_COUNTER:

                $final_data = Flight::getFlightCounter($dates);
                $itemCounter = 0;

                $graph = [
                    'Date'   => [],
                    'Count'  => []
                ];

                foreach ($final_data as $item) {
                    if ($item) {
                        if ($group){
                            $itemCounter += $item->counter;
                        }
                        else {
                            $date_format = date('d M y', strtotime($item->date));

                            $graph["Date"][] = $date_format;
                            $graph["Count"][] = $item->counter;
                        }
                    }
                }
                if ($group){
                    $graph["Date"][] = $label;
                    $graph["Count"][] = $itemCounter;
                }

                return $graph;

            case CHART_PAX_COUNTER_AND_BOUND:
                if ($date_from && $date_to){
                    $dates = [$date_from, $date_to];
                }
                else{
                    $dates = $yesterday;
                }

                $final_data = Flight::getPaxCounter($dates,'outbound');
                $outbound_pax = 0;

                $graph_bound = [
                    'Bound'      => [],
                    'PAX'        => [],
                ];

                $graph = [
                    'Cabin'     => [],
                    'PAX'       => [],
                ];

                foreach ($final_data as $item) {
                    if ($item) {
                        $outbound_pax = round($item->pax_c + $item->pax_y);

                        $graph_bound["Bound"][] = "Outbound";
                        $graph_bound["PAX"][] = $outbound_pax;
                    }
                }

                $final_data = Flight::getPaxCounter($dates);
                foreach ($final_data as $item) {
                    if ($item) {

                        $graph["Cabin"][] = "Business";
                        $graph["PAX"][] = round($item->pax_c);

                        $graph["Cabin"][] = "Economy";
                        $graph["PAX"][] = round($item->pax_y);

                        $inbound_pax = round($item->pax_c + $item->pax_y - $outbound_pax);
                        $graph_bound["Bound"][] = "Inbound";
                        $graph_bound["PAX"][] = $inbound_pax;
                    }
                }
                return [$graph, $graph_bound];

            case CHART_PAX_BOUND:
                if ($date_from && $date_to){
                    $dates = [$date_from, $date_to];
                }
                else{
                    $dates = "2015-07-08";
                }

                $final_data = Flight::getPaxCounter($dates,'outbound');
                $outbound_pax = 0;

                $graph_bound = [
                    'Bound'     => [],
                    'PAX'       => [],
                ];

                foreach ($final_data as $item) {
                    if ($item) {
                        $outbound_pax = round($item->pax_c + $item->pax_y);
                        $graph_bound["Bound"][] = "Outbound";
                        $graph_bound["PAX"][] = $outbound_pax;
                    }
                }

                $final_data = Flight::getPaxCounter($dates);
                foreach ($final_data as $item) {
                    if ($item) {
                        $inbound_pax = round($item->pax_c + $item->pax_y - $outbound_pax);
                        $graph_bound["Bound"][] = "Inbound";
                        $graph_bound["PAX"][] = $inbound_pax;
                    }
                }

                return $graph_bound;

            case CHART_PAX_CABIN:

                $final_data = Flight::getPaxCounter($dates);
                $graph = [
                    'Cabin'     => [],
                    'PAX'       => [],
                ];

                foreach ($final_data as $item) {
                    if ($item) {
                        $graph["Cabin"][] = "Business";
                        $graph["PAX"][] = round($item->pax_c);

                        $graph["Cabin"][] = "Economy";
                        $graph["PAX"][] = round($item->pax_y);
                    }
                }

                return $graph;

            case CHART_REVENUE_SALES_CHANNELS:
                $final_data = PassengerFlight::getRevenue($revenuePeriod, ['field' => 'channel']);
                debug($date_from);
                debug($date_to);


                $graph = [
                    'Channel'      => [],
                    'Revenue'      => [],
                ];

                debug($final_data);

                foreach ($final_data as $i => $each) {
                    $graph["Channel"][] = $each->grouped_field;
                    $graph["Revenue"][] = round($each->revenue);
                }

                return $graph;

            case CHART_REVENUE_TOP_SECTORS:
                $final_data = PassengerFlight::getTopSectors($revenuePeriod);

                $graph = [
                    'Sector'      => [],
                    'Revenue'      => [],
                ];

                foreach ($final_data as $i => $each) {
                    $graph["Sector"][] = $each->departure_airport."-".$each->arrival_airport;
                    $graph["Revenue"][]  = round($each->revenue);
                }

                return $graph;

            case CHART_REVENUE_BY_COUNTRY:
                $final_data = PassengerOrder::revenueByCountry($dates, false, REVENUE_FLOWN);
                $graph = [
                    0 => [
                        'abbr'      => '',
                        'country'   => 'POS',
                        'pax'       => 'PAX',
                        'revenue'   => 'Revenue',
                        'yield'     => 'Yield',
                        'share'     => 'Share,%'
                    ]
                ];

                $totalRevenue = 0;
                array_walk($final_data, function($each) use (&$totalRevenue){
                    array_walk($each, function($item) use (&$totalRevenue){
                        $totalRevenue += $item->revenue;
                    });
                });

                debug($final_data);

                foreach ($final_data as $i => $each) {
                    $yield = round($each->revenue / $each->pax);
                    $graph[] = [
                        'abbr'      => "$each->abbr",
                        'country'   => "$each->country",
                        'revenue'   => round((int)$each->revenue),
                        'pax'       => $each->pax,
                        'yield'     => $yield,
                        'share'     => 100 * round($each->revenue / $totalRevenue, 3)
                    ];
                }
                return $graph;

            case CHART_PAX_REVENUE:
                // Yesterday
                $date[0] = date('y-m-d', strtotime('2015-07-13')); //date('y-m-d', strtotime('-1 days'));
                // Yesterday, Last Year
                $date[1] = date('y-m-d', strtotime("- 1 years", strtotime($date[0])));

                $final_data = PassengerFlight::getFlightPaxRevenueWidget($date[0], $date[1], null, null,'compare','departure_date');

                $graphs = [
                    0 => [
                        "Type/Date" => [],
                        "Revenue"   => []
                    ],
                    1 => [
                        "Type/Date" => [],
                        "PAX"       => []
                    ]
                ];

               /*
                foreach ($types as $type) {
                    foreach ($graphs as $i => $graph){
                        foreach ($date as $each){
                            $graphs[$i][$type] = 0;
                            $graphs[$i]["Date/Period"] = date('d M y', strtotime($each));
                        }
                    }
                }
                */

                foreach($final_data as $i=>$each){
                    $date_format = date('d M y', strtotime($each->date));

                    $graphs[0]["Type/Date"][] = "Flown, ".$date_format;
                    $graphs[0]["Revenue"][] = round($each->revenue);

                    $graphs[1]["Type/Date"][] = "Flown, ".$date_format;
                    $graphs[1]["PAX"][] = round($each->pax);
                }

                $final_data = PassengerFlight::getFlightPaxRevenueWidget($date[0],$date[1], null,null,'compare', 'sales_date');

                foreach($final_data as $each){
                    $date_format = date('d M y', strtotime($each->date));

                    $graphs[0]["Type/Date"][] = "Sold, ".$date_format;
                    $graphs[0]["Revenue"][] = round($each->revenue);

                    $graphs[1]["Type/Date"][] = "Sold, ".$date_format;
                    $graphs[1]["PAX"][] = round($each->pax);
                }

                return $graphs;


            case CHART_PAX_DIRECTIONAL:

                $graphs = [
                    'Type/Date'      => [],
                    'PAX'           => [],
                ];

                if ($date_from && $date_to){
                    if ($revenue_type == REVENUE_FLOWN) {
                        $final_data = PassengerFlight::getRevenue($revenuePeriod, ['field' => 'departure_date']);
                    }
                    else {
                        $final_data = PassengerFlight::getRevenue($revenuePeriod, ['field' => 'sales_date']);
                    }

                    $paxGroup = 0;
                    foreach ($final_data as $each) {
                        if ($group){
                            $paxGroup += $each->pax;
                        }
                        else {
                            $graphs["Type/Date"][] = ucfirst($revenue_type) . ", " . $each->grouped_field;
                            $graphs["PAX"][] = round($each->pax);
                        }
                    }
                    if ($group){
                        $graphs["Type/Date"][] = ucfirst($revenue_type);
                        $graphs["PAX"][] = round($paxGroup);
                    }
                }
                return $graphs;

            case CHART_PAX:

                $graphs = [
                    'Type/Date'     => [],
                    'PAX'           => [],
                ];

                if ($date_from && $date_to){
                    if ($revenue_type == REVENUE_FLOWN) {
                        $final_data = PassengerFlight::getRevenue($revenuePeriod, ['field' => 'departure_date']);
                    }
                    else {
                        $final_data = PassengerFlight::getRevenue($revenuePeriod, ['field' => 'sales_date']);
                    }
                    $paxGroup = 0;
                    foreach ($final_data as $each) {
                        if ($group){
                            $paxGroup += $each->pax;
                        }
                        else {
                            $graphs["Type/Date"][] = ucfirst($revenue_type) . ", " . $each->grouped_field;
                            $graphs["PAX"][] = round($each->pax);
                        }
                    }
                    if ($group){
                        $graphs["Type/Date"][] = ucfirst($revenue_type);
                        $graphs["PAX"][] = round($paxGroup);
                    }
                }
                else {
                    // Yesterday
                    $date[0] = date('y-m-d', strtotime('-1 days')); //date('y-m-d', strtotime('2015-07-13')); //
                    // Yesterday, Last Year
                    $date[1] = date('y-m-d', strtotime("- 1 years", strtotime($date[0])));

                    $final_data = PassengerFlight::getFlightPaxRevenueWidget($date[0], $date[1], null, null, 'compare', 'departure_date');

//                    foreach ($types as $type) {
//                        foreach ($date as $each) {
//                            $date_format = date('d M y', strtotime($each));
//                            $graphs["$type, $date_format"] = ["$type, $date_format", 0, "#ffffff"];
//                        }
//                    }

                    foreach ($final_data as $i => $each) {
                        $date_format = date('d M y', strtotime($each->date));

                        $graphs["Type/Date"][] = "Flown, $date_format";
                        $graphs["PAX"][] = round($each->pax);
                    }


                    $final_data = PassengerFlight::getFlightPaxRevenueWidget($date[0], $date[1], null, null, 'compare', 'sales_date');

                    foreach ($final_data as $each) {
                        $date_format = date('d M y', strtotime($each->date));

                        $graphs["Type/Date"][] = "Sold, $date_format";
                        $graphs["PAX"][] = round($each->pax);
                    }
                }
                return $graphs;

            case CHART_REVENUE:
                // Yesterday
                $date[0] = date('y-m-d', strtotime('-1 days')); //date('y-m-d', strtotime('2015-07-13')); //
                // Yesterday, Last Year
                $date[1] = date('y-m-d', strtotime("- 1 years", strtotime($date[0])));

                $graphs = [
                    'Type/Date'     => [],
                    'PAX'           => [],
                ];

                $compare = true;
                if ($date_from && $date_to){
                    if ($revenue_type == REVENUE_FLOWN) {
                        $final_data = PassengerFlight::getRevenue($revenuePeriod, ['field' => 'departure_date']);
                    }
                    else {
                        $final_data = PassengerFlight::getRevenue($revenuePeriod, ['field' => 'sales_date']);
                    }

                    $revenueGroup = 0;
                    foreach ($final_data as $each) {
                        if ($group){
                            $revenueGroup += $each->revenue;
                        }
                        else {
                            $graphs["Type/Date"][] = ucfirst($revenue_type) . ", " . $each->grouped_field;
                            $graphs["PAX"][] = round($each->revenue);
                        }
                    }
                    if ($group){
                        $graphs["Type/Date"][] = ucfirst($revenue_type);
                        $graphs["PAX"][] = round($revenueGroup);
                    }
                }
                else {
                    $final_data = PassengerFlight::getFlightPaxRevenueWidget($date[0], $date[1], null, null, $compare, 'departure_date');
                    $graphs = [['Date/Period', 'Revenue', ['role' => 'style']]];
                    $types = ['Flown', 'Sold'];

                   /* foreach ($types as $type) {
                        foreach ($date as $each) {
                            $date_format = date('d M y', strtotime($each));
                            $graphs["$type, $date_format"] = ["$type, $date_format", 0, "#ffffff"];
                        }
                    }*/
                    foreach ($final_data as $i => $each) {
                        $date_format = date('d M y', strtotime($each->date));

                        $graphs["Type/Date"][] = "Flown, ".$date_format;
                        $graphs["Revenue"][] = round($each->revenue);
                    }

                    $final_data = PassengerFlight::getFlightPaxRevenueWidget($date[0], $date[1], null, null, 'compare', 'sales_date');

                    foreach ($final_data as $each) {
                        $date_format = date('d M y', strtotime($each->date));

                        $graphs["Type/Date"][] = "Sold, ".$date_format;
                        $graphs["Revenue"][] = round($each->revenue);
                    }
                }
                return $graphs;
        }
    }


    public static function buildChartByName($chartName, $report_period_id = FALSE, $date_from = FALSE, $date_to = FALSE, $revenue_type = FALSE, $label = FALSE, $group = FALSE){
        $yesterday =  date('Y-m-d', strtotime('-1 days'));
        $yesterdayLastYear = date('Y-m-d', strtotime('-1 years', strtotime($yesterday)));

        // Get Period For Revenue Charts
        if ($revenue_type && $revenue_type == REVENUE_SOLD){
            $period['sales_from'] = $date_from;
            $period['sales_to'] = $date_to;
        }
        // By Default Revenue Type is FLOWN
        else {
            $period['departure_from'] = $date_from;
            $period['departure_to'] = $date_to;
        }
        $dates = [$date_from, $date_to];

        $graph = [];
        $counter = 0;
        $colors = [
            '#00d2ff', '#ff7200', '#c3eb00', '#f64040', '#06fc2e', '#fe41d4',
            '#d7d7d7', '#001eff', '#ffda0d', '#dc2659', '#4eff80', '#720059',
            '#00d2ff', '#ff7200', '#c3eb00', '#f64040', '#06fc2e', '#fe41d4',
            '#d7d7d7', '#001eff', '#ffda0d', '#dc2659', '#4eff80', '#720059',
            '#00d2ff', '#ff7200', '#c3eb00', '#f64040', '#06fc2e', '#fe41d4',
            '#d7d7d7', '#001eff', '#ffda0d', '#dc2659', '#4eff80', '#720059',
            '#00d2ff', '#ff7200', '#c3eb00', '#f64040', '#06fc2e', '#fe41d4',
            '#d7d7d7', '#001eff', '#ffda0d', '#dc2659', '#4eff80', '#720059',
            '#00d2ff', '#ff7200', '#c3eb00', '#f64040', '#06fc2e', '#fe41d4',
            '#d7d7d7', '#001eff', '#ffda0d', '#dc2659', '#4eff80', '#720059',
            '#00d2ff', '#ff7200', '#c3eb00', '#f64040', '#06fc2e', '#fe41d4',
            '#d7d7d7', '#001eff', '#ffda0d', '#dc2659', '#4eff80', '#720059',
        ];

        switch ($chartName){
            case CHART_REVENUE_SALES_CHANNELS:
                $counter = 0;

                $final_data = PassengerFlight::getRevenue($period, ['field' => 'channel']);
                $graph[] = ['Channel', 'Revenue', ['role' => 'style']];

                foreach ($final_data as $i => $each) {
                    $counter = $counter % 12;
                    $graph[] = ["{$each->grouped_field}", round($each->revenue), "{$colors[$counter++]}"];
                }
                return $graph;
            case CHART_SEAT_FACTORS:
                $final_data = ReportController::seatFactorsArray($date_from, $date_to, null, 5);
                debug($final_data);
                $graph[] = ['Date/Period', 'Percentage, %', ['role' => 'style']];
                $pax = 0; $config = 0;
                foreach ($final_data as $date => $each) {
                    if ($group){
                        $pax += $each->pax_c + $each->pax_y;
                        $config += $each->config_c + $each->config_y;
                        continue;
                    }
                    $graph[] = [baseDateFormat($date), round($each->sf), "$colors[$counter]"];
                    $counter++;
                }
                if ($group){
                    $sf = $config != 0 ? ($pax / $config) * 100 : 0;
                    $graph[] = [$label, round($sf), "$colors[$counter]"];
                }

                return $graph;

            case CHART_PUNCTUALITY:
                $counter = 0;
                $final_data = ReportController::punctualityArray($date_from, $date_to, true);
                $final_category = $final_data[0];
                $categories = $final_data[1];
                $graph[] = ['Category', 'Percentage, %', ['role' => 'style'] ];
                foreach ($final_category as $index=>$each) {
                    $graph[] = ["$categories[$index]",$each->percentage,"$colors[$counter]"];
                    $counter++;
                }

                return $graph;

            case CHART_FLIGHT_COUNTER:
                $counter = 0;

                $final_data = Flight::getFlightCounter($dates);
                $graph[] = ['Date', 'Count', ['role' => 'style']];
                $itemCounter = 0;
                foreach ($final_data as $item) {
                    if (!is_null($item)) {
                        if ($group){
                            $itemCounter += $item->counter;
                        }
                        else {
                            $date_format = date('d M y', strtotime($item->date));
                            $graph[] = ["$date_format", $item->counter, "$colors[$counter]"];
                            $counter++;
                        }
                    }
                }
                if ($group){
                    $graph[] = [$label, $itemCounter, "$colors[2]"];
                }
                return $graph;

            case CHART_PAX_COUNTER_AND_BOUND:
                $counter2 = 0;
                $final_data = Flight::getPaxCounter($dates,'outbound');
                $graph_bound[] = ['Bound','PAX', ['role' => 'style']];
                $outbound_pax = 0;

                foreach ($final_data as $item) {
                    if ($item) {
                        $outbound_pax = (int)$item->pax_c + (int)$item->pax_y;
                        $graph_bound[] = ["Outbound", $outbound_pax, $colors[$counter2++]];
                    }
                }

                $counter = 0;
                $final_data = Flight::getPaxCounter($dates);
                $graph[] = ['Cabin','PAX', ['role' => 'style']];
                foreach ($final_data as $item) {
                    if (!is_null($item)) {
                        $graph[] = ["Business", (int)$item->pax_c, $colors[$counter++]];
                        $graph[] = ["Economy",  (int)$item->pax_y, $colors[$counter++]];

                        $inbound_pax = (int)$item->pax_c + (int)$item->pax_y - $outbound_pax;
                        $graph_bound[] = ["Inbound", $inbound_pax, $colors[$counter2++]];

                    }
                }
                return [$graph, $graph_bound];
            case CHART_PAX_BOUND:
                $counter = 0;
                $graph_bound[] = ['Bound','PAX', ['role' => 'style']];
                $outbound_pax = 0;
                $inbound_pax = 0;

                $final_data = Flight::getPaxCounter($dates, 'outbound');
                foreach ($final_data as $item) {
                    if ($item) {
                        if ($group){
                            $outbound_pax += (int)$item->pax_c + (int)$item->pax_y;
                            continue;
                        }
                        $outbound_pax = (int)$item->pax_c + (int)$item->pax_y;
                        $graph_bound[] = [baseDateFormat($item->date). ", Outbound", $outbound_pax, $colors[$counter++]];
                    }
                }

                $final_data = Flight::getPaxCounter($dates);
                foreach ($final_data as $item) {
                    if ($item) {
                        if ($group){
                            $inbound_pax += (int)$item->pax_c + (int)$item->pax_y;
                            continue;
                        }
                        $inbound_pax = (int)$item->pax_c + (int)$item->pax_y - $outbound_pax;
                        $graph_bound[] = [baseDateFormat($item->date). ", Inbound", $inbound_pax, $colors[$counter++]];
                    }
                }

                if ($group){
                    $graph_bound[] = ["Period, Outbound", $outbound_pax, $colors[$counter++]];
                    $graph_bound[] = ["Period, Inbound", $inbound_pax, $colors[$counter]];
                }

                return $graph_bound;

            case CHART_PAX_CABIN:

                $final_data = Flight::getPaxCounter($dates);
                $graph[] = ['Cabin','PAX', ['role' => 'style']];
                $business = 0;
                $economy = 0;
                foreach ($final_data as $item) {
                    if ($item) {
                        $paxC = $item->pax_c;
                        $paxY = $item->pax_y;
                        if ($group) {
                            $business += $paxC;
                            $economy += $paxY;
                        }
                        else {
                            $graph[] = [ baseDateFormat($item->date).", Business", (int)$paxC, $colors[$counter++] ];
                            $graph[] = [ baseDateFormat($item->date).", Economy", (int)$paxY, $colors[$counter++] ];
                        }
                    }
                }
                if ($group){
                    $graph[] = [ "Business", (int)$business, $colors[$counter++] ];
                    $graph[] = [ "Economy", (int)$economy, $colors[$counter] ];
                }
                return $graph;

            case CHART_REVENUE_TOP_SECTORS:
                $graph[] = ['Sector', 'Revenue', ['role' => 'style']];
                $final_data = PassengerFlight::getTopSectors($period);
                foreach($final_data as $i=>$each){
                    $sector = $each->departure_airport."-".$each->arrival_airport;
                    $color = $colors[$counter++];
                    $graph[] = [$sector, round((int)$each->revenue), "$color"];
                }
                return $graph;

            case CHART_REVENUE_BY_COUNTRY:
                $final_data = PassengerOrder::revenueByCountry($dates, true, $revenue_type);
                $graph = [
                    0 => [
                        'abbr'      => '',
                        'country'   => 'POS',
                        'pax'       => 'PAX',
                        'revenue'   => 'Revenue',
                        'yield'     => 'Yield',
                        'share'     => 'Share,%'
                    ]
                ];

                $totalRevenue = 0;
                array_walk($final_data, function($each) use (&$totalRevenue){
                    array_walk($each, function($item) use (&$totalRevenue){
                        $totalRevenue += $item->revenue;
                    });
                });


                foreach ($final_data as $i => $each) {
                    $yield = round($each->revenue / $each->pax);
                    $graph[] = [
                        'abbr'      => "$each->abbr",
                        'country'   => "$each->country",
                        'revenue'   => round((int)$each->revenue),
                        'pax'       => $each->pax,
                        'yield'     => $yield,
                        'share'     => 100 * round($each->revenue / $totalRevenue, 3)
                    ];
                }
                debug($group);

                return $graph;

            case CHART_PAX_REVENUE:
                $counter = 0;

                $final_data = PassengerFlight::getFlightPaxRevenueWidget($date_from,$date_to, null,null,'compare','departure_date');

                $graphs =[ 0 => [ ['Date/Period', 'Revenue', ['role' => 'style']] ],  1 => [ ['Date/Period', 'PAX', ['role' => 'style']] ] ];
                $types = ['Flown', 'Sold'];

                foreach ($types as $type) {
                    foreach ($graphs as $i=>$graph){
                        foreach ($dates as $each){
                            $date_format = date('d M y', strtotime($each));
                            $graphs[$i]["$type, $date_format"] = ["$type, $date_format", 0, "#ffffff" ];
                        }
                    }
                }

                foreach($final_data as $i=>$each){
                    $color = $colors[$counter++];
                    $date_format = date('d M y', strtotime($each->date));
                    $graphs[0]["Flown, $date_format"] = ["Flown, $date_format", round($each->revenue), "$color" ];
                    $graphs[1]["Flown, $date_format"] = ["Flown, $date_format", (int)$each->pax, "$color" ];
                }


                $final_data = PassengerFlight::getFlightPaxRevenueWidget($date_from,$date_to, null,null,'compare', 'sales_date');

                foreach($final_data as $each){
                    $color = $colors[$counter++];
                    $date_format = date('d M y', strtotime($each->date));
                    $graphs[0]["Sold, $date_format"] = ["Sold, $date_format", round($each->revenue), "$color" ];
                    $graphs[1]["Sold, $date_format"] = ["Sold, $date_format", (int)$each->pax, "$color" ];
                }
                if (count($final_data) < 2){

                }
                $graphs[0] = array_values($graphs[0]);
                $graphs[1] = array_values($graphs[1]);
                return $graphs;


            case CHART_PAX_DIRECTIONAL:
                $graphs = [['Date/Period', 'PAX']];
                if ($revenue_type == REVENUE_FLOWN) {
                    $final_data = PassengerFlight::getRevenue($period, ['field' => 'departure_date']);
                }
                else {
                    $final_data = PassengerFlight::getRevenue($period, ['field' => 'sales_date']);
                }

                $paxGroup = 0;
                foreach ($final_data as $each) {
                    if ($group){
                        $paxGroup += $each->pax;
                    }
                    else {
                        $graphs[] = [ucfirst($revenue_type) . ", " . $each->grouped_field, round($each->pax)];
                    }
                }
                if ($group){
                    $graphs[] = [ucfirst($revenue_type), round($paxGroup)];
                }

                return $graphs;

            case CHART_PAX:
                $counter = 0;

                if ($date_from && $date_to){
                    if ($revenue_type == REVENUE_FLOWN) {
                        $final_data = PassengerFlight::getRevenue($period, ['field' => 'departure_date']);
                    }
                    else {
                        $final_data = PassengerFlight::getRevenue($period, ['field' => 'sales_date']);
                    }
                    $graphs = [['Date/Period', 'PAX']];
                    $paxGroup = 0;
                    foreach ($final_data as $each) {
                        if ($group){
                            $paxGroup += $each->pax;
                        }
                        else {
                            $graphs[] = [ucfirst($revenue_type) . ", " . $each->grouped_field, round($each->pax)];
                        }
                    }
                    if ($group){
                        $graphs[] = [ucfirst($revenue_type), round($paxGroup)];
                    }
                }
                else {
                    $final_data = PassengerFlight::getFlightPaxRevenueWidget($date_from, $date_to, null, null, 'compare', 'departure_date');

                    $graphs = [['Date/Period', 'PAX', ['role' => 'style']]];
                    $types = ['Flown', 'Sold'];

                    foreach ($types as $type) {
                        foreach ($dates as $each) {
                            $date_format = date('d M y', strtotime($each));
                            $graphs["$type, $date_format"] = ["$type, $date_format", 0, "#ffffff"];
                        }
                    }

                    foreach ($final_data as $i => $each) {
                        $color = $colors[$counter++];
                        $date_format = date('d M y', strtotime($each->date));
                        $graphs["Flown, $date_format"] = ["Flown, $date_format", (int)$each->pax, "$color"];
                    }


                    $final_data = PassengerFlight::getFlightPaxRevenueWidget($date_from, $date_to, null, null, 'compare', 'sales_date');

                    foreach ($final_data as $each) {
                        $color = $colors[$counter++];
                        $date_format = date('d M y', strtotime($each->date));
                        $graphs["Sold, $date_format"] = ["Sold, $date_format", (int)$each->pax, "$color"];
                    }
                    if (count($final_data) < 2) {

                    }
                    $graphs = array_values($graphs);
                }
                return $graphs;

            case CHART_REVENUE:
                if ($revenue_type == REVENUE_FLOWN) {
                    $final_data = PassengerFlight::getRevenue($period, ['field' => 'departure_date']);
                }
                else {
                    $final_data = PassengerFlight::getRevenue($period, ['field' => 'sales_date']);
                }
                debug($final_data);


                $graphs = [['Date/Period', 'Revenue', ['role' => 'style']]];
                $revenueGroup = 0;
                foreach ($final_data as $each) {
                    if ($group){
                        $revenueGroup += $each->revenue;
                    }
                    else {
                        $graphs[] = [ucfirst($revenue_type) . ", " . $each->grouped_field, round($each->revenue), "{$colors[$counter++]}"];
                    }
                }
                if ($group){
                    $graphs[] = [ucfirst($revenue_type), round($revenueGroup), "{$colors[$counter++]}"];
                }
                return $graphs;
        }
    }


    public static function getChartJS($chartName, $searchFields){
        $graph = [];
        switch($chartName) {
            case CHART_REVENUE_BY_SALES_DATE:
                // Made It for Google Chart
                $data = PassengerFlight::getRevenue($searchFields, ['field' => 'sales_date'], "sales_date");
                $graph = [
                    'Date'      => [],
                    'Revenue'   => [],
                ];

                foreach ($data as $each) {
                    $graph['Date'][] = $each->grouped_field;
                    $graph['Revenue'][] = round($each->revenue);
                }
                break;
        }
        return $graph;
    }

    public static function getC3Charts($chartName, $searchFields){
        $finalData = [];
        switch($chartName){
            case CHART_REVENUE_SALES_CHANNELS:
                $data = PassengerFlight::getRevenue($searchFields, ['field' => 'channel']);
                foreach ($data as $each) {
                    $finalData[] = [$each->grouped_field, round($each->revenue)];
                }
                break;
            case CHART_REVENUE_BY_RBD:
                $data = PassengerFlight::getRevenue($searchFields, ['field' => 'rbd']);
                foreach ($data as $each) {
                    $finalData[] = [$each->grouped_field, round($each->revenue)];
                }
                debug($finalData);
                break;
            case CHART_REVENUE_BY_COUNTRY:
                $data = PassengerFlight::getRevenue($searchFields, ['field' => 'country']);
                foreach ($data as $each) {
                    $finalData[] = [$each->grouped_field, round($each->revenue)];
                }
                break;
            case CHART_REVENUE_BY_SALES_DATE:
                // Made It for Google Chart
                $data = PassengerFlight::getRevenue($searchFields, ['field' => 'sales_date'], "sales_date");
                /*$finalData = [
                    0   => ['x'],
                    1   => ['Revenue']
                ];*/
//                $finalData = [['Airport', 'Percentage']];

                foreach ($data as $each) {
                    $finalData[] = [$each->grouped_field, round($each->revenue)];
//                    $finalData[0][] = $each->grouped_field;
//                    $finalData[1][] = round($each->revenue);
                }
                break;
            case CHART_REVENUE:
                $data = PassengerFlight::getRevenue($searchFields, ['field' => 's_flights__cabin.cabin']);
                foreach ($data as $each) {
                    $finalData[] = [$each->grouped_field, round($each->revenue)];
                }
                break;
        }
        return $finalData;
    }
}
