<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14
 * Time: 11:53
 */

class ChangeLog extends Eloquent {
    protected $table = "change_log";
    public $timestamps = true;

    /**
     * Log 1 Variable Change at a time
     * @param $user_id
     * @param $table
     * @param $variable
     * @param $value_before
     * @param $value
     */
    public static function LogChange($user_id, $table, $variable, $value_before, $value){
        if ($value != $value_before) {
            debug('LOG');
            $log = new ChangeLog();
            $log->user_id = $user_id;
            $log->table_name = $table;
            $log->variable = $variable;
            $log->variable_name = ucwords(str_replace('_',' ', $variable));
            $log->value = is_array($value) ? implode(', ', $value) : $value;
            $log->value_before = is_array($value_before) ? implode(', ', $value_before) : $value_before;
//            $log->created_by = Auth::user()->id;
//            $log->updated_by = Auth::user()->id;
            $log->save();
        }

    }


    /**
     * Log Record Change (multiple Variable Change,  array as serialized string)
     * @param $user_id
     * @param $table
     * @param $value_before
     * @param $value
     */
    public static function LogChangeArray($user_id, $table, $value_before, $value, $model = null){
        sort($value_before);
        sort($value);
        if ($value != $value_before) {
            $log = new ChangeLog();
            $log->user_id = $user_id;
            $log->is_array = 1;
            $log->table_name = $table;
            $log->model = $model;
            $log->value = is_null($value) ? null :serialize($value);
            $log->value_before = is_null($value_before) ? null : serialize($value_before);
//            $log->created_by = Auth::user()->id;
//            $log->updated_by = Auth::user()->id;
            $log->save();
        }
    }
}