<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;

class BspReport extends Eloquent
{
    protected $table = "bsp_report";
    public $timestamps = false;



    public static function getApg($ObjectApgId, $ApgPeriod){
      $selected =

          BspReport::leftJoin('bsp_apg', function($join) {
            $join->on('bsp_report.apg', '=', 'bsp_apg.id');
          })
            ->where('bsp_apg.id','=', $ObjectApgId)
            ->first(["bsp_apg.$ApgPeriod"])[$ApgPeriod];//[0][$ApgPeriod];

        return $selected;
    }

    public static function getApg3($ObjectApgId){
        $selected =

            BspReport::leftJoin('bsp_apg', function($join) {
                $join->on('bsp_report.apg', '=', 'bsp_apg.id');
            })
                ->where('bsp_apg.id','=', $ObjectApgId)->first();

        return $selected;
    }




    public  static function checkRows($array){
        $result = BspReport::select(['country_id','date'])
                            ->where('country_id', $array['country_id'])
                            ->where('date', $array['date']);
        return $result->first();
    }
    public static  function updatdeRow($array){

        $result = BspReport::where('country_id', $array['country_id'])
            ->where('date', $array['date'])
            ->update(array(

                'period1_cash'   => $array['period1_cash'],
                'period1_credit' => $array['period1_credit'],
                'period2_cash'   => $array['period2_cash'],
                'period2_credit' => $array['period2_credit'],
                'period3_cash'   => $array['period3_cash'],
                'period4_cash'   => $array['period4_cash'],
                'period4_credit' => $array['period4_credit'],
                'currency'        => $array['currency'],
                'acm_airep'       => $array['acm_airep'],
                'acm_date'        => $array['acm_date'],
                'acm_apg'         =>  BspReportApg::insertGetId(array( 'date'      =>$array['date'],
                                                                       'country'   => $array['country_id'],
                                                                       'acm_apg'   => $array['acm_apg'],
                                                                       'acm_apg_1' => $array['acm_apg_1'],
                                                                       'acm_apg_2' => $array['acm_apg_2'],
                                                                       'acm_apg_3' => $array['acm_apg_3'],
                                                                       'acm_apg_4' => $array['acm_apg_4'],
                                                                       'adm_apg'   => $array['adm_apg'],
                                                                       'adm_apg_1' => $array['adm_apg_1'],
                                                                       'adm_apg_2' => $array['adm_apg_2'],
                                                                       'adm_apg_3' => $array['adm_apg_3'],
                                                                       'adm_apg_4' => $array['adm_apg_4'],
                                                                       'acm_iata'  => $array['acm_iata'] ,
                                                                       'adm_iata'  => $array['adm_iata']
                                                                    )),
                'net_ex_taxes'   =>  $array['net_ex_taxes'],

                'taxes_p1'       =>  $array['taxes_p1'],
                'taxes_p2'       =>$array['taxes_p2'],
                'taxes_p3'       => $array['taxes_p3'],
                'taxes_p4'       => $array['taxes_p4'] ));



        return $result;


    }

}