<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class AirlineService extends Eloquent implements AuditableContract{

    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "airlines__services";

    public $timestamps = true;

    protected $guarded = [
        "id",
        "created_at",
        "updated_at"
    ];

    public function airline(){
        return $this->belongsTo("App\\Models\\Airline", "airline_id");
    }

    public function airport(){
        return $this->belongsTo("App\\Models\\Airport", "airport_id");
    }

    public function service(){
        return $this->belongsTo("App\\Models\\Service", "service_id");
    }

    public static function getServices($airline_id, $airport_id, $occStaffOnly = null){
        $data = AirlineService::with(['service'])
            ->join("services", "services.id", "=", "airlines__services.service_id")
            ->orderBy("services.position");

        if ($occStaffOnly){
            $data->where("abbr", OCC);
        }

        $airport_id = is_array($airport_id) ? $airport_id : [$airport_id];

        return $data->where("airline_id", $airline_id)
                     ->whereIn("airport_id", $airport_id)
                     ->get([
                         "airlines__services.*"
                     ]);
    }

    public static function getAirlineServices($airlineID){
        return AirlineService::with(["airport", "service"])
                ->join("services", "services.id", "=", "airlines__services.service_id")
                ->orderBy("services.position")
                ->where("airline_id", $airlineID)
                ->orderBy("airport_id")
                ->orderBy("service_id")
                ->orderBy("start_date")
                ->get(["airlines__services.*"]);
    }

    public static function getSlaListAndAirports($sla){
        $slaByAirports = [];
        $airports = [];
        foreach ($sla as $each) {

            if (!isset($slaByAirports[$each->airport->iata])){
                $slaByAirports[$each->airport->iata] = [];
                $airports[$each->airport->iata] = $each->airport->id;
            }

            $slaByAirports[$each->airport->iata][] = $each;
        }

        return [$slaByAirports, $airports];
    }

    public static function getServicesByAirlineAndAirport($airlines = null, $airports = null){

        $airlineFunctions =  self::with('service')->select();

        if ($airlines){
            $airlines = is_array($airlines) ? $airlines : [];
            if (count($airlines)){
                $airlineFunctions->whereIn("airline_id", $airlines);
            }
        }

        if ($airports){
            $airports = is_array($airports) ? $airports : [];
            if (count($airports)){
                $airlineFunctions->whereIn("airport_id", $airports);
            }
        }

        $airlineFunctions = $airlineFunctions->get();

        $result = [];
        foreach ($airlineFunctions as $each) {
            if (!isset($result[$each->airline_id])){
                $result[$each->airline_id] = [];
            }

            if (!isset($result[$each->airline_id][$each->airport_id])){
                $result[$each->airline_id][$each->airport_id] = [];
            }

            $result[$each->airline_id][$each->airport_id][] = $each;
        }

        return $result;
    }
}
