<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.

 */
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class AirlineLicense extends Eloquent implements AuditableContract{

    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "airlines__licenses";

    public $timestamps = true;

    protected $guarded = [
        "id",
        "created_at",
        "updated_at"
    ];

    public function airline(){
        return $this->belongsTo("App\\Models\\Airline", "airline_id");
    }

    public function service(){
        return $this->belongsTo("App\\Models\\Service", "service_id");
    }

    public function license(){
        return $this->belongsTo("App\\Models\\License", "license_id");
    }

    public static function getServicesAndSelectedLicenses($airline){
        $airlineServices = AirlineService::with(['service'])
            ->join("services", "services.id", "=", "airlines__services.service_id")
            ->orderBy("services.position")
            ->where("airline_id", $airline->id)
            ->get(["airlines__services.*"]);

        $airlineServicesUnique = $airlineServices->unique("service_id")
                            ->keyBy("service_id");


        $airlineServicesIds = array_keys($airlineServicesUnique->all());
        sort($airlineServicesIds);

        $selectedLicenses = [];
        $services = [];

        foreach ($airlineServicesIds as $serviceId) {
            $airlineLicenses = AirlineLicense::with('license')
                ->where("airline_id", $airline->id)
                ->where("service_id", $serviceId)
                ->get();

            if (!isset($selectedLicenses[$serviceId])){
                $selectedLicenses[$serviceId] = [];
                $services[$serviceId] = $airlineServicesUnique[$serviceId]->service;
            }

            foreach ($airlineLicenses as $airlineLicense) {
                $selectedLicenses[$serviceId][] = $airlineLicense->license; //$airlineLicense->license_id;
            }
        }

        return [$services, $selectedLicenses];
    }
}
