<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
*/

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class AirlineLibrary extends Eloquent implements AuditableContract{

    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "airlines__library";

    public $timestamps = true;

    public function airline(){
        return $this->belongsTo("App\\Models\\Airline", "airline_id");
    }

    public function signs(){
        return $this->hasMany(LibrarySign::class, "airline_library_id");
    }

    public function lastSign(){
        return $this->hasOne(LibrarySign::class, "airline_library_id")->orderBy("created_at", "DESC");
    }


    public static function uploadedAirlineLibraries(&$staffAirlines){
        foreach ($staffAirlines as &$each) {
            $counter = 0;
            $updated = null;
            if ($each->airline->library && $each->airline->library->count()){
                $counter = count($each->airline->library->where("deleted_at", null)->all());
                $updated = $each->airline->library->last()->updated_at;
            }

            $each->airline->libraries = $counter;
            $each->airline->libraries_updated = $updated;
        }

    }

}
