<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

/**
 * Created by PhpStorm.

 */

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class Airline extends Eloquent implements AuditableContract{

    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "airlines";

    public $timestamps = true;

    public function country(){
        return $this->belongsTo('App\Models\Country', "country_id");
    }

    public function airlineService(){
        return $this->hasMany('App\Models\AirlineService', "airline_id");
    }

    public function library(){
        return $this->hasMany('App\Models\AirlineLibrary', "airline_id");
    }

    public function aircraft(){
        return $this->hasMany(Aircraft::class, "airline_id");
    }

    public function aircraftType(){
        return $this->hasMany(AircraftType::class, "airline_id");
    }

    public function delay(){
        return $this->hasMany('App\Models\Delay', "airline_id");
    }

    public function flightNumber(){
        return $this->hasMany('App\Models\FlightNumber', "airline_id");
    }

    public static function aircraftTypes($airline){
        $acTypes = [];
        /*
        foreach ($airline->aircraft as $each) {
            if ($each->type && !array_key_exists($each->aircraft_type_id, $acTypes)){
                $acTypes[$each->aircraft_type_id] = $each->type;
            }
        }
        */
        foreach ($airline->aircraftType as $each) {
            if (!array_key_exists($each->id, $acTypes)){
                $acTypes[$each->id] = $each;
            }
        }
        return $acTypes;
    }

    public static function listHandlingAirlines($value = "airline", $key = "id"){
        $list = Airline::where("handling_airline", true)
            ->whereNotNull($value)
            ->where($value, "!=", "")
            ->orderBy("airline")
            ->pluck($value, $key)
            ->all();

        return mergeOperatorAirlineList($list, $value, $key);
    }

    public static function listCode(){
        $list = Airline::where("handling_airline", true)
            ->orderBy("airline")
            ->get([
                DB::raw("IF(iata = '', icao, iata) AS airline_code"),
                "id"
            ])
            ->pluck("airline_code", "id")
            ->all();

        return $list;
    }


    public static function listHandlingAirlinesWithCode($value = "icao", $key = "id"){
        $reserve = $value == IATA ? ICAO : IATA;

        $list = Airline::select([
            DB::raw("CONCAT(airline, ' (', IF({$value} is NULL OR {$value} = '', IF({$reserve} is NULL OR {$reserve} = '', '', {$reserve}), {$value}) , ')') AS code"),
            $key
        ])
            ->where("handling_airline", true)
            ->orWhere("operator", 1)
            ->orderBy("airline")
            ->pluck("code", $key)
            ->all();

        return $list;
    }

    public static function getHandlingAirlinesAndOperatorsWithCode($value = "icao", $key = "id"){
        $reserve = $value == IATA ? ICAO : IATA;

        $list = Airline::select([
            DB::raw("CONCAT(airline, ' (', IF({$value} is NULL OR {$value} = '', IF({$reserve} is NULL OR {$reserve} = '', '', {$reserve}), {$value}) , ')') AS code"),
            $key
        ])
            ->where("handling_airline", true)
            ->orWhere("operator", 1)
            ->orderBy("airline")
            ->get([
                "code",
                $key,
            ]);

        return $list;
    }


    public static function getAirlinesAndOperatorsWithCode($value = "icao", $key = "id"){
        $reserve = $value == IATA ? ICAO : IATA;

        $list = Airline::select([
            DB::raw("CONCAT(airline, ' (', IF({$value} is NULL OR {$value} = '', IF({$reserve} is NULL OR {$reserve} = '', '', {$reserve}), {$value}) , ')') AS code"),
            $key
        ])
//            ->where("handling_airline", true)
//            ->orWhere("operator", 1)
            ->orderBy("airline")
            ->get([
                "code",
                $key,
            ]);

        return $list;
    }

    public static function getSelectedAirlineIds(Request $request){
        $selectedAirline = $request->get("airline_id");

        $selectedAirlines = $request->get("airline_ids");

        if ($selectedAirline == ""){
            return StaffAirline::currentStaffAirlinesList();
        }
        else {
            if ($selectedAirlines && count($selectedAirlines)) {
                if ($selectedAirline && in_array($selectedAirline, $selectedAirlines)) {
                    $selectedAirlineIds = array_diff($selectedAirlines, [$selectedAirline]);
                }
                else if (in_array("", $selectedAirlines) && count($selectedAirlines) > 1) {
                    $selectedAirlineIds = StaffAirline::currentStaffAirlinesList();
                }
                else {
                    $selectedAirlineIds = $selectedAirline ? array_merge([$selectedAirline], $selectedAirlines) : $selectedAirlines;
                }
            }
            else {
                if ($selectedAirline){
                    if (is_array($selectedAirline)) {
                        $selectedAirlineIds = $selectedAirline;
                    }
                    else {
                        $selectedAirlineIds = explode(",", $selectedAirline);
                    }
                }
                else {
                    $selectedAirlineIds = StaffAirline::currentStaffAirlinesList();
                }
            }
        }

        $result = count($selectedAirlineIds) ? $selectedAirlineIds : StaffAirline::currentStaffAirlinesList();

        return $result;
    }
}
