<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 21.08.14

 */
use Illuminate\Support\Facades\DB;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class AircraftType extends Eloquent implements AuditableContract {

    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table ="aircraft__types";

    protected $guarded = ["id", "created_at", "updated_at"];

    public $timestamps = true;

    public static function getAirlineTypes($airlineID, $perPage = 50){
        $result = AircraftType::whereNull("deleted_at")
            ->where("airline_id", $airlineID)
            ->orderBy("airline_id")
            ->orderBy("name");

        if ($perPage){
            return $result->paginate($perPage);
        }

        return $result->get();
    }

    public static function getAirlineTypesList($airlineID){
        return AircraftType::whereNull("deleted_at")
            ->where("airline_id", $airlineID)
            ->orderBy("airline_id")
            ->orderBy("name")
            ->pluck("iata_name", "id")
            ->all();
    }

    public static function findByName($name, $airline = null){
        $findAircraftType = AircraftType::where(function($sql) use ($name){
            $sql->where("name", $name)
                ->orWhere("iata_name", $name)
                ->orWhere("icao", $name);
        });

        if ($airline){
            $findAircraftType->where("airline_id", $airline->id);
        }

        return $findAircraftType->first();
    }

    public function aircraft()
    {
        return $this->hasMany(Aircraft::class);
    }

    public function airline()
    {
        return $this->belongsTo(Airline::class);
    }

    public static function getList(){
        if (airlineModule()){
            return Aircraft::join("aircraft__types", "aircraft.aircraft_type_id", "=", "aircraft__types.id")
                        ->select([
                            "aircraft__types.id as id",
                            DB::raw("IFNULL(s_aircraft__types.icao, s_aircraft__types.iata_name) AS fName"),
                        ])
                        ->whereNull("aircraft.deleted_at")
                        ->whereNull("aircraft__types.deleted_at")
                        ->orderBy("fName")
                        ->groupBy("id")
                        ->pluck("fName", "id")
                        ->all();
        }
        else {
             return AircraftType::leftJoin("airlines", "airlines.id", "=", "aircraft__types.airline_id")
                                ->select([
                                    "aircraft__types.id AS id",
                                    DB::raw("CONCAT(IFNULL(s_airlines.iata, ''), '-', s_aircraft__types.iata_name) AS fName"),
                                ])
                                ->where("aircraft__types.iata_name", "!=", "")
                                ->whereNotNull("aircraft__types.iata_name")
                                ->orderBy("airline_id")
                                ->pluck("fName", "id")
                                ->all();
        }
    }

    public static function byAirline($selectedAirlineIds = null, $list = null){

            if (airlineModule()){
            /*
            $result = Aircraft::join("aircraft__types", "aircraft.aircraft_type_id", "=", "aircraft__types.id")
                                ->whereNull("aircraft.deleted_at")
                                ->whereNull("aircraft__types.deleted_at")
                                ->orderBy("iata_name")
                                ->groupBy("aircraft.aircraft_type_id")
                                ->get([
                                        "aircraft_type_id AS id",
                                        "aircraft__types.icao AS name"
                                ])
                                ->toArray();
            */

            $result = AircraftType::whereNull("deleted_at")
                    ->orderBy("icao")
                    ->get([
                        "id",
                        "icao AS name"
                    ]);

            if ($list){
                $array = [];
                foreach ($result as $item) {
                    if ($item["id"]){
                        $array[$item["id"]] = $item["name"];
                    }
                }

                return $array;
            }

            return $result;
        }
        else {
            if (!$selectedAirlineIds) {
                return [];
            }

            $aircraftTypes = AircraftType::with("airline")
                ->whereNull("deleted_at")
                ->whereIn("airline_id", is_array($selectedAirlineIds) ? $selectedAirlineIds : [$selectedAirlineIds])
                ->orderBy("airline_id")
                ->orderBy("iata_name")
                ->get();

            $result = $airlines = [];

            foreach ($aircraftTypes as $each) {

                if (!isset($result[$each->airline_id])) {
                    $result[$each->airline_id] = [];

                    $result[$each->airline_id][] = [
                        "id" => "",
                        "name" => "",
                    ];
                }

                $result[$each->airline_id][] = [
                    "id" => $each->id,
                    "name" => ($each->airline ? $each->airline->iata . "-" : "") . $each->iata_name,
                ];

                // $result[$each->airline_id][$each->id] = $each->name;

            }

            /*
            foreach ($airlines as $each) {
                asort($result[$each]);
            }
            */

            if ($list){
                $array = [];
                foreach ($result as $airlineID => $items) {
                    foreach ($items as $item) {
                        if ($item["id"]){
                            $array[$item["id"]] = $item["name"];
                        }
                    }
                }

                return $array;
            }
        }

        return $result;
    }
}
