<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\DB;


/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 21.08.14

 */

use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class Aircraft extends Eloquent implements AuditableContract
{
    use Auditable;

    protected $auditExclude = [
        'updated_by',
        'created_by',
    ];

    protected $table = "aircraft";

    public $timestamps = true;

    public function type()
    {
        return $this->belongsTo("App\\Models\\AircraftType", "aircraft_type_id");
    }

    public function airline()
    {
        return $this->belongsTo("App\\Models\\Airline", "airline_id");
    }

     public function engine()
    {
        return $this->belongsTo(AircraftEngine::class, "engine_id");
    }

    public function forwardbooking(){
        return $this->hasMany('App\\Models\\ForwardBooking','aircraft_id');
    }

    public function maintenance()
    {
        // second param is the key in aircrafts_maintenances table, which I use for connect these rows
        return $this->hasMany("App\\Models\\Maintenance", "aircraft_id");
    }

    public function flight()
    {
        return $this->hasMany("App\\Models\\Flight", "aircraft_id");
    }

    public function capacity()
    {
        return $this->hasMany("App\\Models\\FlightNumberAircraftCapacity", "aircraft_id");
    }

    public static function getList(){
        return Aircraft::whereNull("deleted_at")
                    ->orderBy("name")
                    ->pluck("name", "id")
                    ->all();
    }

    public static function getAirlineAircraft($airlineID, $perPage = null){
        $result = Aircraft::whereNull("deleted_at")
            ->where("airline_id", $airlineID)
            ->orderBy("airline_id")
            ->orderBy("name");

        if ($perPage){
            return $result->paginate($perPage);
        }

        return $result->get();
    }

    public static function getAircraftByAirline($selectedAirlineIds = null, $list = null){

        if (airlineModule()){
            $result = [[ "id"    => "", "name"  => ""]] + Aircraft::whereNull("deleted_at")
                    ->orderBy("name")
                    ->get([
                        "id",
                        "name"
                    ])
                    ->toArray();

            if ($list){
                $array = [];
                foreach ($result as $item) {
                    if ($item["id"]){
                        $array[$item["id"]] = $item["name"];
                    }
                }

                return $array;
            }

            return $result;
        }

        if (!$selectedAirlineIds || (is_array($selectedAirlineIds) && !count($selectedAirlineIds))){
            return [];
        }

        $aircraft = Aircraft::whereNull("deleted_at")
                            ->whereIn("airline_id", is_array($selectedAirlineIds) ? $selectedAirlineIds : [$selectedAirlineIds])
                            ->orderBy("airline_id")
                            ->orderBy("name")
                            ->get();

        $result = $airlines = [];

        foreach ($aircraft as $each) {

            if (!isset($result[$each->airline_id])){
                $result[$each->airline_id] = [];

                $result[$each->airline_id][] = [
                    "id"    => "",
                    "name"  => "",
                ];
            }

            $result[$each->airline_id][] = [
                "id"    => $each->id,
                "name"  => $each->name,
            ];

            // $result[$each->airline_id][$each->id] = $each->name;

        }

        /*
        foreach ($airlines as $each) {
            asort($result[$each]);
        }
        */

        if ($list){
            $array = [];
            foreach ($result as $arr) {
                foreach ($arr as $item) {
                    if ($item["id"]){
                        $array[$item["id"]] = $item["name"];
                    }
                }
            }

            return $array;
        }

        return $result;
    }

    public static function getAircraftByTypeAndAirline(){

        $aircraft = Aircraft::whereNull("deleted_at")
                            ->get();

        $acType = [
            ''  => []
        ];

        foreach ($aircraft as $each) {
            $type = $each->aircraft_type_id ? $each->aircraft_type_id : "";

            if (!isset($acType[$type])){
                $acType[$type] = [];
            }
            if (!isset($acType[$type][$each->airline_id])){
                $acType[$type][$each->airline_id] = [];
            }

            $obj = new \stdClass();
            $obj->id = $each->id;
            $obj->name = $each->name;

            $acType[$type][$each->airline_id][] = $obj;
        }

        return $acType;
    }

    public static function byType($selectedAirlineIds){

        if (airlineModule()){
            $aircraft = Aircraft::whereNull("deleted_at")
                    ->orderBy("name")
                    ->get();
        }
        else {
            if (!$selectedAirlineIds) {
                return [];
            }
            else {
                $aircraft = Aircraft::whereNull("deleted_at")
                    ->whereIn("airline_id", is_array($selectedAirlineIds) ? $selectedAirlineIds : [$selectedAirlineIds])
                    ->orderBy("airline_id")
                    ->orderBy("name")
                    ->get();
            }
        }

        $result = [
            ''  => []
        ];

        foreach ($aircraft as $each) {
            $type = $each->aircraft_type_id ? $each->aircraft_type_id : "";

            if (!isset($result[$type])){
                $result[$type] = [""];
            }

            $result[$type][$each->id] = $each->name;
        }

        return $result;
    }



    public static function getFlightAircraftSeatConfig($flight){

        $result = [
            "wide_board"    => null,
            "config"        => [],
            "aircraft"      => $flight ? $flight->aircraft : null,
        ];

        if (!$flight){
            return $flight;
        }

        $aircraft = $flight->aircraft;
        $aircraftType = $flight->aircraftType;

        $result["wide_board"] = aircraftWideBoard($aircraft, $aircraftType);

        $object = null;

        if ($aircraft && $aircraft->config_y_details) {
            $object = $aircraft;
        }
        else if ($aircraftType) {
            $object = $aircraftType;
        }
        else if ($aircraft) {
            $object = $aircraft->type;
        }

        if ($object) {
            if ($object->config_a_details) {
                $result["config"]["a"] = unserialize($object->config_a_details);
                $result["config"]["a"]["columns"] = array_reverse(self::getColumn($result["config"]["a"]));
            }
            if ($object->config_c_details) {
                $result["config"]["b"] = unserialize($object->config_c_details);
                $result["config"]["b"]["columns"] = array_reverse(self::getColumn($result["config"]["b"]));
            }
            if ($object->config_w_details) {
                $result["config"]["w"] = unserialize($object->config_w_details);
                $result["config"]["w"]["columns"] = array_reverse(self::getColumn($result["config"]["w"]));
            }
            if ($object->config_y_details) {
                $result["config"]["e"] = unserialize($object->config_y_details);
                $result["config"]["e"]["columns"] = array_reverse(self::getColumn($result["config"]["e"]));
            }
        }

        return $result;
    }

    public static function getAircraftSeatConfig($aircraft){

        $result =  [
            "a" => [],
            "b" => [],
            "w" => [],
            "e" => [],
        ];

        if ($aircraft){

            if ($aircraft->config_a_details){
                $result["a"] = unserialize($aircraft->config_a_details);

                $result["a"]["columns"] = array_reverse(self::getColumn($result["a"]));
            }
            if ($aircraft->config_c_details){
                $result["b"] = unserialize($aircraft->config_c_details);

                $result["b"]["columns"] = array_reverse(self::getColumn($result["b"]));
            }
            if ($aircraft->config_w_details){
                $result["w"] = unserialize($aircraft->config_w_details);

                $result["w"]["columns"] = array_reverse(self::getColumn($result["w"]));
            }
            if ($aircraft->config_y_details){
                $result["e"] = unserialize($aircraft->config_y_details);

                $result["e"]["columns"] = array_reverse(self::getColumn($result["e"]));

            }
        }

        return $result;
    }

    public static function getColumn($data){
        $types = [
            "columns_l",
            "columns_m",
            "columns_r",
        ];

        $columns = [];
        foreach ($types as $i => $type) {
            if (isset($data[$type])){
                foreach ($data[$type] as $each) {
                    $columns[] = $each;
                }
                if ($i != count($types) - 1){
                    $columns[] = "_";
                }
            }
        }

        return $columns;
    }

    public static function getParameters($aircraft, $aircraftParameters){
        $aircraftCurrentParameters = [];

        foreach ($aircraftParameters as $key => $param)
        {
            $query = AircraftHistory::select(['parameter', 'value'])
                ->where('aircraft_id', $aircraft->id)
                ->where("parameter", $key)
                ->orderBy('created_at', 'DESC')
                ->first();


            $aircraftCurrentParameters[$key] = "";
            if ($query)
            {
                $aircraftCurrentParameters[$key] = $query->value;
            }
        }
        /*
        $subQuery = AircraftHistory::select(['parameter', 'value'])
                                    ->where('aircraft_id', $aircraft->id)
                                    ->orderBy('created_at', 'DESC');

        $aircraftCurrentParametersDB = DB::table( DB::raw("({$subQuery->toSql()}) as subQuery") )
            ->mergeBindings($subQuery->getQuery()) // Get Underlying Query Builder
            ->groupBy('parameter')
            ->get();


        foreach ($aircraftParameters as $key => $param)
        {
            $aircraftCurrentParameters[$key] = "";
            if (count($aircraftCurrentParametersDB))
            {
                foreach ($aircraftCurrentParametersDB as $paramDb)
                {
                    if ($paramDb->parameter == $key)
                    {
                        $aircraftCurrentParameters[$key] = $paramDb->value;
                    }
                }
            }
        }
        */

        return $aircraftCurrentParameters;
    }


    public static function groupData($flights, $data = [
        "acTypes",
        "aircraft",
        "sectors",
        "flightNumbers",
        "flights",
    ]){

        $acTypes = $aircraft = $sectors = $flightNumbers = $filteredFlights = [];

        $totalPlanned = $totalActual = $totalFlying = $totalActualFlights = 0;

        // Filters
        $filteredACTypes = \request("aircraftType");
        $filteredAC = \request("aircraft");

        if ($filteredACTypes instanceof AircraftType){
            $filteredACTypes = $filteredACTypes->id;
        }

        if ($filteredAC instanceof Aircraft){
            $filteredAC = $filteredAC->id;
        }

        $filteredACTypes = $filteredACTypes ? (is_array($filteredACTypes) ? $filteredACTypes : [$filteredACTypes]) : null;
        $filteredAC = $filteredAC ? (is_array($filteredAC) ? $filteredAC : [$filteredAC]) : null;

        $dateSearch = getFormPeriod();

        foreach ($flights as $each) {

            if (!$each->aircraft){
                continue;
            }

            if ($filteredAC && !in_array($each->aircraft_id, $filteredAC)){
                continue;
            }

            $ACTypeID = $each->aircraft->aircraft_type_id;
            if ($filteredACTypes && count($filteredACTypes)){
                if (!$ACTypeID || ($ACTypeID && !in_array($each->aircraft->aircraft_type_id, $filteredACTypes))){
                    continue;
                }
            }

            $initialDep = $each->ptd && $each->ptd != EMPTY_DATETIME ? $each->ptd : $each->std;
            $initialArr = $each->pta && $each->pta != EMPTY_DATETIME ? $each->pta : $each->sta;

            // Double Filter Flights for removing out of date flights
            if ($dateSearch && $initialDep){
                if (isset($dateSearch["from"]) && isset($dateSearch["to"]) && $dateSearch["from"] && $dateSearch["to"]){
                    $dep = strtotime(date("Y-m-d", strtotime($initialDep)));

                    if ($dep < strtotime($dateSearch["from"]) || $dep > strtotime($dateSearch["to"]) ){
                        continue;
                    }
                }
                else if (isset($dateSearch["month"]) && isset($dateSearch["month"]) && $dateSearch["year"] && $dateSearch["year"]){
                    $month = date("m", strtotime($initialDep));
                    $year = date("Y", strtotime($initialDep));

                    if (! ($year == $dateSearch["year"] && in_array($month, $dateSearch['month']))){
                        continue;
                    }
                }
            }
            // END

            // Planned
            $totalPlanned += ($planned = $initialDep && $initialDep != EMPTY_DATETIME && $initialArr && $initialArr != EMPTY_DATETIME
                                && strtotime($initialArr) > strtotime($initialDep) ? Calculate_Duration($initialDep, $initialArr) : 0);
            // Actual
            $totalActual  += ($actual = $each->atd && $each->atd != EMPTY_DATETIME && $each->ata && $each->ata != EMPTY_DATETIME
                                 && strtotime($each->ata) > strtotime($each->atd) ?  Calculate_Duration($each->atd, $each->ata) : 0);
            // Flying
            $totalFlying  += ($flying =  $each->abn && $each->abn != EMPTY_DATETIME && $each->tdn && $each->tdn != EMPTY_DATETIME
                                && strtotime($each->tdn) > strtotime($each->abn) ? Calculate_Duration($each->abn, $each->tdn) : 0);

            if ($actual){
                $totalActualFlights++;
            }

            // Aircraft Type
            if (in_array("acTypes", $data)) {
                $index = $each->aircraft->type ? $each->aircraft->aircraft_type_id : null;
                if (!array_key_exists($index, $acTypes)) {
                    $acTypes[$index] = [
                        "aircraftType"  => $each->aircraft->type,
                        "flights"       => 0,
                        "flying"        => 0,
                        "planned"       => 0,
                        "actual"        => 0,
                        "actualFlights" => 0,
                    ];
                }

                $acTypes[$index]['flights']++;
                $acTypes[$index]['flying'] += $flying;
                $acTypes[$index]['planned'] += $planned;
                $acTypes[$index]['actual'] += $actual;
                if ($actual){
                    $acTypes[$index]['actualFlights'] ++;
                }
            }

            // Aircraft
            if (in_array("aircraft", $data)) {
                if (!array_key_exists($each->aircraft_id, $aircraft)) {
                    $aircraft[$each->aircraft_id] = [
                        "aircraft"  => $each->aircraft,
                        "flights"       => 0,
                        "flying"        => 0,
                        "planned"       => 0,
                        "actual"        => 0,
                        "actualFlights" => 0,
                    ];
                }

                $aircraft[$each->aircraft_id]['flights']++;
                $aircraft[$each->aircraft_id]['flying'] += $flying;
                $aircraft[$each->aircraft_id]['planned'] += $planned;
                $aircraft[$each->aircraft_id]['actual'] += $actual;
                if ($actual){
                    $aircraft[$each->aircraft_id]['actualFlights'] ++;
                }
            }

            // Sector
            if (in_array("sectors", $data)) {

                $sector = getFlightSector($each);
                if (!array_key_exists($sector, $sectors)) {
                    $sectors[$sector] = [
                        "sector"    => $sector,
                        "flights"       => 0,
                        "flying"        => 0,
                        "planned"       => 0,
                        "actual"        => 0,
                        "actualFlights" => 0,
                    ];
                }

                $sectors[$sector]['flights']++;
                $sectors[$sector]['flying'] += $flying;
                $sectors[$sector]['planned'] += $planned;
                $sectors[$sector]['actual'] += $actual;
                if ($actual){
                    $sectors[$sector]['actualFlights'] ++;
                }
            }

            // Flight Number
            if (in_array("flightNumbers", $data)) {

                $flightNumber = getFlightNumber($each);
                if (!array_key_exists($flightNumber, $flightNumbers)) {
                    $flightNumbers[$flightNumber] = [
                        "flightNumber"  => $each->flightNumber,
                        "fn"            => $flightNumber,
                        "flights"       => 0,
                        "flying"        => 0,
                        "planned"       => 0,
                        "actual"        => 0,
                        "actualFlights" => 0,
                    ];
                }

                $flightNumbers[$flightNumber]['flights']++;
                $flightNumbers[$flightNumber]['flying'] += $flying;
                $flightNumbers[$flightNumber]['planned'] += $planned;
                $flightNumbers[$flightNumber]['actual'] += $actual;
                if ($actual){
                    $flightNumbers[$flightNumber]['actualFlights'] ++;
                }
            }

            // Flight
            if (in_array("flights", $data)) {
                if (!array_key_exists($each->id, $filteredFlights)) {
                    $filteredFlights[$each->id] = [
                        'initialDep'    => $each->ptd && $each->ptd != EMPTY_DATETIME ? $each->ptd : $each->std,
                        'initialArr'    => $each->pta && $each->pta != EMPTY_DATETIME ? $each->pta : $each->sta,
                        "planned"       => $planned,
                        "actual"        => $actual,
                        "flying"        => $flying,
                        "flight"        => $each,
                    ];
                }
            }
        }

        return [
            "acTypes"       => $acTypes,
            "aircraft"      => $aircraft,
            "sectors"       => $sectors,
            "flightNumbers" => $flightNumbers,
            "flights"       => $filteredFlights,

            "totalFlights"  => count($filteredFlights),
            "totalPlanned"  => $totalPlanned,
            "totalActual"   => $totalActual,
            "totalFlying"           => $totalFlying,
            "totalActualFlights"    => $totalActualFlights,
        ];
    }
}
