<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */

class AgencyCode extends Eloquent {
    protected $table = "agency__codes";
    public $timestamps = true;

    protected $guarded = [
        "id",
        "created_at",
        "updated_at"
    ];

    public function agency(){
        return $this->belongsTo('App\Models\Agency', 'agency_id');
    }

    public function city(){
        return $this->belongsTo('App\Models\City', 'city_id');
    }

    public function country(){
        return $this->belongsTo('App\Models\Country', 'country_id');
    }

    public function region(){
        return $this->belongsTo('App\Models\Region', 'region_id');
    }

    public static function getCodeAndAgency($code_id){
        $where = "s_agency__codes.id IN (";
        if (is_array($code_id))
            $where .= implode(',',$code_id);
        else
            $where .= $code_id;
        $where .= ")";

        $data2 = AgencyCode::selectRaw('s_agency__codes.id, agency, code')
            ->join('agency', 'agency__codes.agency_id', '=', 'agency.id')
            ->whereRaw($where)
            ->get();

        return $data2;
    }

    public static function getByCountry($countryIDs, $agencyID = null){
        $agencyCodes = AgencyCode::with([
            "agency",
            "city",
            "country",
        ]);

        if ($agencyID){
            $agencyCodes->where("agency_id", $agencyID);
        }

        if ($countryIDs && count($countryIDs)) {
            $agencyCodes->where(function($sql) use ($countryIDs){
                $sql->whereIn("country_id", $countryIDs)
                    ->orWhereNull("country_id");
            });
        }

        return $agencyCodes->get();
    }


}
