<?php namespace App\Models; use Illuminate\Database\Eloquent\Model as Eloquent;
use Illuminate\Support\Facades\DB;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */

class Agency extends Eloquent {
    protected $table = "agency";
    public $timestamps = true;

    protected $guarded = [
        "id",
        "created_at",
        "updated_at"
    ];


    public function city(){
        return $this->belongsTo('App\Models\City', 'city_id');
    }

    public function salesChannel(){
        return $this->belongsTo('App\Models\SalesChannel', 'sales_channel_id');
    }

    public function country(){
        return $this->belongsTo('App\Models\Country', 'country_id');
    }

    public function region(){
        return $this->belongsTo('App\Models\Region', 'region_id');
    }

    public function passengerOrders(){
        return $this->hasManyThrough('App\Models\PassengerOrder', 'App\Models\AgencyCode', 'agency_id', 'agency_code_id')
                    ->orderBy('sales_date', 'DESC');
    }

    public function passengerOrdersWithCondition($conditions){
        $result =  $this->hasManyThrough('App\Models\PassengerOrder', 'App\Models\AgencyCode', 'agency_id', 'agency_code_id');
        //Apply Conditions
        handleConditions($result, $conditions);

        return $result->get();
    }

    public static function getByCountry($countryIDs = null){
        $result = Agency::select([
            "agency.id as id",
            DB::raw("CONCAT(agency, ', ', country) as name"),
        ])
            ->leftJoin("countries", "countries.id", "=", "agency.country_id");

        if ($countryIDs && count($countryIDs)){
            $result->whereIn("country_id", $countryIDs);
        }

        $result = $result->orderBy("country_id")
                         ->orderBy("name")
                         ->pluck("name", "id")
                         ->all();

        return $result;
    }

    public static function getAgenciesByCountry($countryIDs = null){
        $result = Agency::select([
            "id",
            "country_id",
            "agency",
        ]);

        if ($countryIDs && count($countryIDs)){
            $result->whereIn("country_id", $countryIDs);
        }

        $result = $result->groupBy("country_id", "id")
                        ->orderBy("country_id")
                        ->orderBy("agency")
                        ->get();

        $list = [];
        foreach ($result as $each) {
            if (!isset($each->country_id)){
                $list[$each->country_id] = [];
            }

            $list[$each->country_id][] = [
                "id"        => $each->id,
                "agency"    => $each->agency,
            ];
        }


        return $list;
    }


}
