<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class SimpleTextEmail extends Mailable
{
    use Queueable, SerializesModels;

    protected $fromAddress;
    public $subject;

    public $content;

    /**
     * @param $fromAddress
     * @param $content
     * @param string $subject
     */
    public function __construct($content, $subject = "", $fromAddress = null)
    {
        $this->content = $content;
        $this->fromAddress = $fromAddress;
        $this->subject = $subject;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $this->subject($this->subject);

        if ($this->fromAddress){
            $this->from($this->fromAddress);
        }

        return $this->text('emails.types.simple-text');
    }

    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */
    public function envelope()
    {
//        return new Envelope(subject: 'Simple Text Email');
    }

    /**
     * Get the message content definition.
     *
     * @return \Illuminate\Mail\Mailables\Content
     */
    public function content()
    {
//        return new Content(view: 'view.name',);
    }

    /**
     * Get the attachments for the message.
     *
     * @return array
     */
    public function attachments()
    {
        return [];
    }
}
