<?php

namespace App\Http\Middleware;

use App\Models\UserModule;
use App\Models\UserPageView;
use Closure;
use Illuminate\Foundation\Application;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\URL;

class PermissionRequiredMiddleware
{
    protected $app;

    public function __construct(Application $app, Request $request) {
        $this->app = $app;
//        $this->request = $request;
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle($request, Closure $next)
    {
        // Check if a user is logged in.
        if (!$user = $request->user())
        {
            return $next($request); // abort(404);
        }


        if (!isUserAllowedToLogin($user)){
            debug("OUT");
            session()->flush(); // remove all the session data

            Auth::logout(); // logout user

            return redirect()->to("auth/logout");
        }

        if ($user->user_role_id == ROLE_SUPER_ADMIN){
            // No permissions to check, allow access.
            return $next($request);
        }


        // Get the current route.
        $route = $request->route();

        // Get the current route actions.
        $actions = $route->getAction();

        $module = $actions['module'];
        $otherModuleNames = isset($actions['other_module_names']) && $actions['other_module_names']
                        && is_array($actions['other_module_names']) ? $actions['other_module_names'] : null;

        // module link
        $moduleUrl = $request->path() ? $request->path(): ($actions['as'] ?? null);

        $userRoles = $actions['user_roles'] ?? null;
        $exceptionUserIDs = $actions['exception_user_ids'] ?? null;

        $skipLog = $actions['skip_log'] ?? null;

        // Check if we have any permissions to check the user has.
        $permissions = $actions['permissions'] ?? null;
        if (!$permissions)
        {
//            if (!$skipLog){
                UserPageView::SaveLog($user, $module, $moduleUrl, $permissions, $userRoles, true, $skipLog);
//            }

            // No permissions to check, allow access.
            return $next($request);
        }

        $permissions = is_array($permissions) ? $permissions : [$permissions];

        // Fetch all of the matching user permissions.
        $userPermissions =  UserModule::join("modules", "modules.id", "=", "users__modules.module_id")
                                      ->join("modules__permissions", "modules__permissions.id", "=", "users__modules.module_permission_id");

        if ($exceptionUserIDs && in_array($user->id, $exceptionUserIDs)){
            // Access is granted.
//            if (!$skipLog) {
                UserPageView::SaveLog($user, $module, $moduleUrl, $permissions, $userRoles, true, $skipLog);
//            }
        }
        else if ($userRoles){
            $userRoles = is_array($userRoles) ? $userRoles : [$userRoles];

            $userPermissions->join("users", "users.id", "=", "users__modules.user_id")
                            ->join("users__roles", "users__roles.id", "=", "users.user_role_id")
                            ->whereIn("users__roles.role", $userRoles);

        }

        if ($otherModuleNames){
            $userPermissions->where(function($sql) use ($module, $otherModuleNames){
                $sql->where("modules.name", $module)
                    ->orWhereIn("modules.name", $otherModuleNames);
            });
        }
        else {
            $userPermissions->where("modules.name", $module);
        }

        $userPermissions = $userPermissions->where("user_id", $user->id)
                                           ->whereIn('modules__permissions.name', $permissions)
                                           ->get()
                                           ->toArray();

        // Check if we require all permissions, or just one.
        if (isset($actions['permissions_require_all']))
        {
            // If user has EVERY permission required.
            if (count($permissions) == count($userPermissions))
            {
                // Access is granted.
//                if (!$skipLog) {
                    UserPageView::SaveLog($user, $module, $moduleUrl, $permissions, $userRoles, true, $skipLog);
//                }

                return $next($request);
            }
        } else {
            // If the user has the permission.
            if (count($userPermissions) >= 1)
            {
                // Access is granted and the rest of the permissions are ignored.
//                if (!$skipLog) {
                    UserPageView::SaveLog($user, $module, $moduleUrl, $permissions, $userRoles, true, $skipLog);
//                }

                return $next($request);
            }
        }


        if (isset($actions['profile_page']) && $actions["profile_page"]){
            return $next($request);
        }

//        if (!$skipLog) {
            UserPageView::SaveLog($user, $module, $moduleUrl, $permissions, $userRoles, null, $skipLog);
//        }

        return redirect()->to("error/401");
        // If we reach this far, the user does not have the required permissions.
//        return view("smart/ajax/error401"); //
    }
}
