<?php

namespace App\Http\Controllers;

use App\Models\UserPageView;
use App\Models\UserTracking;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class UserTrackingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        ini_set("max_execution_time", 120);
        ini_set('memory_limit', '256M');

        $date = date("Y-m-d H:i:s", strtotime(" - 3 days"));
        $date7 = date("Y-m-d H:i:s", strtotime(" - 1 days"));

        $usersTracking = UserTracking::with(["user", "user.location", "user.location.airport"]);
        $pageViews = UserPageView::with(["user", "user.location", "user.location.airport"]);

        $grandAdmin = Auth::user()->id == 44;
        if (!$grandAdmin){
            $usersTracking->whereNotNull("user_id");
        }

        if ($request->get("user_id")){
            $date = date("Y-m-d H:i:s", strtotime(" - 1 months"));
            $date7 = date("Y-m-d H:i:s", strtotime(" - 1 months"));

            $usersTracking->where("user_id", $request->get("user_id"));
            $pageViews->where("user_id", $request->get("user_id"));
        }

        $usersTracking = $usersTracking->where("created_at", ">=", $date)
                                        ->orderBy("created_at", "DESC")
                                        ->get();

        $pageViews = $pageViews->where("created_at", ">=", $date7)
                                ->whereNull("skip")
                                ->orderBy("created_at", "DESC")
                                ->get();

        $this->viewData = [
            "grandAdmin"        => $grandAdmin,
            'usersTracking'     => $usersTracking,
            'pageViews'         => $pageViews,
        ];

        return view("user-tracking/index", $this->viewData);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
