<?php

namespace App\Http\Controllers;

use App\Models\LibraryView;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserNotificationsController extends Controller
{
    public function index(){
        $auth = Auth::user();

        $auth->notifications->markAsRead();

        $this->viewData = [
            "user"              => $auth,
            "authUser"          => $auth,
            "libraryViews"      => LibraryView::getAuthLibrarySignDocs($auth, true),
        ];

        return view("user-notifications.index", $this->viewData);
    }

}
