<?php

namespace App\Http\Controllers;

use App\Models\ModulePermission;
use App\Models\User;
use App\Models\UserModule;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;

class UserModuleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * @param Request $request
     * @param $user
     * @return int
     */
    public function update(Request $request, $user)
    {
        debug($request->all());

//        $module = $request->get("module");
        $permissions = $request->get("permission");

        if (!$permissions){
            return redirect()->back();
        }

        $allPermissions = ModulePermission::pluck("module_id", "id")
                                            ->all();

        $userModules = UserModule::where('user_id', $user->id)
                                    ->get()
                                    ->keyBy("module_permission_id")
                                    ->toArray();

        $processedPermissions = [];
        foreach ($permissions as $permission) {
            if (!array_key_exists($permission, $userModules)){
                $newModule = new UserModule();
                $newModule->user_id = $user->id;
                $newModule->module_id = isset($allPermissions[$permission]) ? $allPermissions[$permission] : null;
                $newModule->module_permission_id = $permission;
                $newModule->save();
            }
            $processedPermissions[] = $permission;
        }

        // Delete Others
        $uModules = UserModule::where('user_id', $user->id)
                    ->whereNotIn("module_permission_id", $processedPermissions)
                    ->get();
        // Audit Deleted
        auditDeleted($uModules);


        return redirect()->back();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }



    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
