<?php namespace App\Http\Controllers;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 11.08.14

 */

use App\Classes\Image\CropAvatar;
use App\Forms\LeaveRequestForm;
use App\Models\Airline;
use App\Models\ApplicationStatus;
use App\Models\Condition;
use App\Models\Department;
use App\Models\StaffService;
use App\Models\User;
use App\Models\UserEntitlement;
use App\Models\UserLeaveRequest;
use App\Models\UserLeaveStatus;
use App\Models\UserPageView;
use App\Repositories\Interfaces\IAccessTypeRepository;
use App\Repositories\Interfaces\IApplicationStatusRepository;
use App\Repositories\Interfaces\ILeaveRepository;
use App\Repositories\Interfaces\IOrganizationRepository;
use App\Repositories\Interfaces\IUserEntitlementRepository;
use App\Repositories\Interfaces\IUserLeaveRequestRepository;
use App\Repositories\Interfaces\IUserLeaveStatusRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;
use App\Forms\UserForm;

use App\Repositories\Interfaces\ICabinCrewRepository;

class UserController extends Controller
{
    public $leaveExceedLimit = 5;

    public function showUsers()
    {
        $users = $this->user->getAllUsers();
        return compact('users');
    }

    public function getUser($id)
    {
        $user = $this->user->getUserById($id);
        return view('user.profile', compact('user'));
    }

    /**
     * Login user
     * @return mixed
     */
    public function login(IAccessTypeRepository $accessType)
    {
        if ($this->isPostRequest()) {
            $validator = $this->getLoginValidator();

            if ($validator->passes()) {
                $credentials = $this->getLoginCredentials();
                if (Auth::attempt($credentials)) {
                    if (Auth::user()->status === USER_ACTIVE) {
                        // Check If Access Type is Set
                        if (Auth::user()->user_access_type_id) {
                            $userAccessType = $accessType->find(Auth::user()->user_access_type_id);
                            if ($userAccessType) {
                                switch ($userAccessType->type) {
                                    case STAFF:
                                        return redirect()->route('homepage');// view('user/test');
                                        /*if (Session::has('preLoginUrl'))
                                            return redirect()->to(Session::get('preLoginUrl'));*/
//                                        return redirect()->to("report/punctuality");
//                                        return redirect()->route("homepage");
                                        break;
                                    case LINE_MAINTENANCE:
                                        return redirect()->to('fleetwatch/index');
                                        break;
                                }
                            }
                        } else {
                            //return redirect()->route("homepage");
                        }
                    } else {
                        debug('Logout');
                        Auth::logout();
                        return redirect()->back()
                            ->withErrors([
                                "account" => ["Account is not authorized, please contact with website administrator."]
                            ]);
                    }
                } else {
                    return redirect()->back()
                        ->withErrors([
                            "password" => ["Credentials invalid."]
                        ]);
                }
            } else {
                return redirect()->back()
                    ->withInput()
                    ->withErrors($validator);
            }
        }

        if (Auth::check()) {
            //return redirect()->route('homepage');
        }
        return view("user/login");
    }

    /**
     * Logout user from the system
     * @return mixed
     */
    public function logout()
    {
        Auth::logout();
        Session::flush();
        return redirect()->route('user/login')
            ->with('message', 'You are now logged out!');
    }


    /**
     * @return \Illuminate\View\View
     */
    public function test()
    {
        return view('user/test');
    }

    /**
     * Edit User
     * @return mixed
     */
    /* public function edit(Guard $auth)
     {
         $subDepartments = ["" => "Select Subdivision"];
         $positions = ["" => "Select Position"];
         $userId = \request("id");
         $user = $this->user->getUserFullInformation($userId);
         $form = new UserForm();
         $url = URL::full();
         debug(request()->all());

         if ($this->isPostRequest()) {
             debug(request()->all());
             if (\request("imageSave") || \request("imageDelete")) {
                 if (\request("imageDelete")){
                     $user->picture = null;
                     $user->thumb = null;
                     $user->save();

                     return redirect()->to($url)
                         ->withInput()
                         ->with("message", "Profile Photo Successfully Deleted");
                 }
                 else {
                     if (\request()->hasFile('profile_image')) {
                         $rules = ['file' => 'required|image|mimes:jpeg,jpg,png,bmp,gif,svg'];
                         $file = ['file' => \request()->file('profile_image')];
                         $validator = Validator::make($file, $rules);
                         debug($file);

                         if ($validator->fails()) {
                             return redirect()->to($url)
                                 ->withInput()
                                 ->withErrors($validator);
                         } else {
                             debug($file['file']->getRealPath());

                             $fileName = $userId . '.' . $file['file']->getClientOriginalExtension();
                             $fileNameThumb = $userId . '_thumb.' . $file['file']->getClientOriginalExtension();
                             $pathFile = public_path('assets/img/users/' . $fileName);
                             $pathFileThumb = public_path('assets/img/users/' . $fileNameThumb);

                             // Picture Save
                             saveProfilePhoto($file['file'], $pathFile, null, 300, 80);
                             // Thumb Save
                             saveProfilePhoto($file['file'], $pathFileThumb, null, 100, 80);

                             $this->user->updateById($userId, ['picture' => $fileName, 'thumb' => $fileNameThumb]);


                             return redirect()->to($url)
                                 ->withInput()
                                 ->with("message", "Profile Photo Successfully Updated");
                         }
                     }
                     else {
                         return redirect()->to($url)
                             ->withInput()
                             ->withErrors(['Please Choose Picture.']);
                     }
                 }
             }
             else {
                 if ($form->isValidForEdit()) {
                     $userAttr = [
                         'first_name'        => \request("first_name"),
                         'last_name'         => \request("last_name"),
                         'is_contractor'     => \request("is_contractor"),
                         'email'             => \request("email"),
                         'dob'     => \request("dob"),
                         'location'          => \request("location"),
                         'birth_place'       => \request("birth_place"),
                         'nationality'       => \request("nationality"),
                         'idcard_number'     => \request("idcard_number"),
                         'idcard_expiration' => \request("idcard_expiration"),
                         //'languages'         => serialize(\request("language")),
                         'phone'             => serialize([
                             "office"  => \request("phone_office"),
                             "home"    => \request("phone_home"),
                             "mobile1" => \request("phone_mobile1"),
                             "mobile2" => \request("phone_mobile2")
                         ]),
                         'passport'          => serialize([
                             "p_number"      => \request("p_number"),
                             "p_issued_date" => \request("p_issued_date"),
                             "p_exp_date"    => \request("p_exp_date")
                         ])
                     ];

                     if (\request("new_password")) {
                         $userAttr['password'] = Hash::make(\request("new_password"));
                     }

                     $subDepartmentId = \request("subdepartment_id");
                     $departmentId = \request("department_id");

                     $userDepartmentAttr['department_id'] = $departmentId;
                     $userDepartmentAttr['subdepartment_id'] = $subDepartmentId;

                     if (\request("position_id") && \request("position_id")) {
                         if (\request("position_id") == "other" && \request("other_position")) {

                             $position = $this->position->firstOrCreate([
                                 "title"             => \request("other_position"),
                                 "subdepartment_id"  => $subDepartmentId,
                                 "department_id"     => $departmentId ]);

                             $userDepartmentAttr['position_id'] = $position->id;
                         } else {
                             $userDepartmentAttr['position_id'] = \request("position_id");
                         }
                     }

                     // Find User Department Or Create Otherwise
                     $userDepartment = $this->userDepartment->firstOrCreate(['user_id' => $userId]);
                     // Update User Department
                     $this->userDepartment->update($userDepartment, $userDepartmentAttr);
                     // Update User Information
                     $this->user->updateById($userId, $userAttr);

                     return redirect()->to($url)
                         ->withInput()
                         ->with("message", "Account information was successfully updated");
                 }
                 return redirect()->to($url)
                     ->withInput()
                     ->withErrors($form->getErrors());
             }
         }
         else {
             if ($user->subdepartment_id || $user->has_subdepartment) {
                 if ($user->subdepartment_id || $user->has_subdepartment) {
                     $subDepartments = $this->subDepartment->findAndListModelVariable(["department_id" => $user->department_id], ['val' => "name", 'key' => "id"], "");

                     if ($user->has_subdepartment) {
                         if ($user->subdepartment_id) {
                             $positions = $this->position->findAndListModelVariable(["subdepartment_id" => $user->subdepartment_id], ['val' => "title", 'key' => "id"], "");
                         } else {
                             $positions = $this->position->findAndListModelVariable(["department_id" => $user->department_id, 'subdepartment_id' => null], ['val' => "title", 'key' => "id"], "");
                         }
                     } else {
                         $positions = $this->position->findAndListModelVariable(["department_id" => $user->department_id], ['val' => "title", 'key' => "id"], "");
                     }
                 } elseif ($user->department_id) {
                     $positions = $this->position->findAndListModelVariable(["department_id" => $user->department_id, 'subdepartment_id' => null], ['val' => "title", 'key' => "id"], "");
                 }
             }
         }


         return view("user/edit", [
             "departments" => getDepartmentListByRole($auth),
             "nationality" => ["" => "Select Nationality"] + nationalities(),
             "placeOfBirth" => ["" => "Select Country"] + CountryList(),
             "userSubdepartment"  => $user->subdepartment_id,
             "userPosition"       => $user->position_id,
             "subDepartments" => $subDepartments,
             "positions" => $positions + ["other" => "Other"],
             "location" => ["" => "----Select----"] + Location::pluck('city_id', 'id'),
             "user" => $user
         ]);
     }*/

    /**
     * Request action to get link for reset password
     * @return mixed
     */
    public function request()
    {
        if ($this->isPostRequest()) {
            $response = $this->getPasswordRemindResponse();
            if ($this->isInvalidUser($response)) {
                return redirect()->back()
                    ->withInput()
                    ->with("error", Land::get($response));
            }
            return redirect()->back()
                ->with("status", Lang::get($response));
        }

        return view("user/request");
    }

    /**
     * @param $token
     * @return mixed
     */
    public function reset($token = null)
    {
        if ($this->isPostRequest()) {
            $credentials = \request()->only("email", "password", "password_confirmation") + compact("token");
            $response = $this->resetPassword($credentials);
            if ($response === Password::PASSWORD_RESET) {
                return redirect()->route("homepage");
            }
            return redirect()->back()
                ->withInput()
                ->with("error", Lang::get($response));
        }
        return view("user/reset", [
            "token" => $token
        ]);
    }


    /**
     * Create A New User
     */
    public function create()
    {
        debug(Session::all());
        $this->viewData = [
            'departments' => Department::listDepartments()
        ];
        return view('user/create', $this->viewData);
    }

    /**
     *  Save A New User
     * @param IOrganizationRepository $organization
     * @return $this|\Illuminate\Http\RedirectResponse
     */
    public function store(IOrganizationRepository $organization)
    {
        $form = new UserForm();

        if ($form->isValidForCreation()) {

            $first_name = \request("first_name");
            $last_name = \request("last_name");
            $email = \request("email");
            $structure_department_id = \request("structure_department_id") ? \request("structure_department_id") : null;
            $structure_position_id = \request("structure_position_id") ? \request("structure_position_id") : null;
            $password = \request("password");
            $password_confirmation = \request("password_confirmation");

            if ($password) {
                if ($password !== $password_confirmation) {
                    return redirect()->to('user/create')
                        ->withInput()
                        ->withErrors(['Passwords Do Not Match']);
                }
            } else {
                $password = generateRandomPassword();
            }

            // Check If There Are No Duplications in First/Last Names Combination
            $searchUsersByName = $this->user->findByAttributes([
                'first_name' => $first_name,
                'last_name' => $last_name,
            ]);

            if ($searchUsersByName) {
                return redirect()->to('user/create')
                    ->withInput()
                    ->withErrors([
                        'User With The Given First/Last Name Combination Already Exists, Make Sure Below Record Is Not Your Record',
                        'First Name: ' . $searchUsersByName->first_name,
                        'Last Name: ' . $searchUsersByName->last_name,
                        'Email: ' . $searchUsersByName->email,
                        'DOB: ' . $searchUsersByName->dob
                    ]);
            }

            // Create If All of The Above Checks Return False
            $userObject = $this->user->createByAttributes([
                'first_name' => $first_name,
                'last_name' => $last_name,
                'email' => $email,
                'password' => Hash::make($password),
                'tmp_password' => $password
            ]);

            $organization->firstOrCreate([
                'user_id' => $userObject->id,
                'structure_department_id' => $structure_department_id,
                'structure_position_id' => $structure_position_id
            ]);

            flash()->success('New User Successfully Created');
        } else {
            return redirect()->to('user/create')
                ->withInput()
                ->withErrors($form->getErrors());
        }

        return redirect()->to('user/upload-photo/' . $userObject->id);
    }

    public function uploadPhoto($id)
    {

        $user = User::find($id);

        if (!$user) {
            return view('error/404');
        }

        $organization = $this->organization->findByAttributes(['user_id' => $id]);

        $this->viewData = [
            'user' => $user,
            'first_name' => $user->first_name,
            'last_name' => $user->last_name,
            'email' => $user->email,

            'position' => $organization->structure_position_id,
            'positions' => $this->position->listModelVariable(['name', 'id']),

            'department' => $organization->structure_department_id,
            'departments' => $this->department->listModelVariable(['name', 'id']),

            'picture' => $user->picture ? asset("storage/users/" . $user->picture) : asset("/assets/img/default-user-picture.png"),
        ];

        return view('user/upload-photo', $this->viewData);
    }


    public function updatePhoto($id)
    {

        $user = User::find($id);

        if (!$user) {
            return view('error/404');
        }
        // Get URL
        $url = \URL::full();

        if (\request("imageSave") || \request("imageDelete")) {
            profilePhoto($user, true, $url, 'users');
        }

        return redirect()->to('user/' . $id . '/edit');
    }


    /**
     * Get User Organization Full Details
     * @param $user_id
     * @return mixed
     */
    protected function getOrganizationFullDetails($user_id)
    {
        $organization = $this->organization->findAllByAttributes([
            'organization.user_id' => $user_id
        ],
            [],
            [
                'organization.id AS id',
                'user_id',
                'organization_level_id',
                'level',
                'organization.structure_department_id',
                'organization.structure_position_id',
                'report_to_user_id',
                'table_id',
                'tables.name AS table_name',
                'table_value_id',
            ],
            [
                ['organization__level', 'organization__level.id', '=', 'organization.organization_level_id'],
                ['organization__details', 'organization__details.organization_id', '=', 'organization.id'],
                ['tables', 'tables.id', '=', 'organization__details.table_id'],
            ]
        );
        return $organization;
    }


    public function leaveEmployeeActions(Request $request, IUserLeaveRequestRepository $userLeaveRequestRep,
                                         IUserLeaveStatusRepository $userLeaveStatusRep,
                                         IApplicationStatusRepository $applicationStatus,
                                         IUserEntitlementRepository $userEntitlementRepository){

        $leaveStatus = null;
        $leaveRequest = null;
        $user = Auth::user();

        if (\request("leave_request_id")) {
            $leaveRequest = $userLeaveRequestRep->find(\request("leave_request_id"));
            // Get Leave Statuses
            if ($leaveRequest) {
                $leaveStatus = $leaveRequest->leaveStatus;
            }
        }
        elseif (\request("leave_status_id") && \request("leave_status_id")){
            $leaveStatus = $userLeaveStatusRep->find(\request("leave_status_id"));
            // Get Leave Request
            if ($leaveStatus) {
                $leaveRequest = $leaveStatus->leaveRequest;
            }
        }

        if (!$leaveRequest && !$leaveStatus){
            flash()->error('Error! Record Not Found');
            return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
        }

        $status = ApplicationStatus::pluck("id", "status")->all();

        $leaveId = \request("leave_id");

        $datePeriod = json_decode(\request("date_period"));

        $reasons = \request("reasons") ? \request("reasons") : null;

        debug($request->all());

        if ($request->get('cancel')){

            if ($leaveRequest->leave && $leaveRequest->leave->name == ANNUAL_LEAVE) {

                $entitlement = $userEntitlementRepository->findByAttributes([
                    'user_id'   => $user->id,
                    'year'      => date('Y', strtotime($leaveRequest->date_from))
                ]);

                $this->ChangeEntitlement($leaveRequest, $entitlement, CANCELLED);
            }

            // Mark As Cancelled
            $leaveRequest->status_id = $status[APPLICATION_STATUS_CANCELLED];

            // Cancelled By Employee -> in NOTES
            $previousNotes = $leaveRequest->notes;
            $notes = "-Cancelled by Employee(".baseDateFormat(date("Y-m-d H:i:s"), true).")";
            $leaveRequest->notes = $previousNotes == null || $previousNotes == "" ? $notes : $previousNotes.'<br/>'.$notes;
            $leaveRequest->save();


            if ($leaveStatus && count($leaveStatus)){
                // MARK EVERYONE'S STATUS AS VOID
                foreach ($leaveStatus as &$each) {
                    $each->status_id = $status[APPLICATION_STATUS_VOID];
                    $each->save();
                }
            }

            debug($request->all());

            flash()->error('Leave request successfully cancelled');
            return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
        }
        else {
            // Validate Form
            $form = new LeaveRequestForm();

            if ($form->isValidSaveApplyForLeave()){
                $from = date("Y-m-d H:i:s", strtotime($datePeriod->start));
                $to = date("Y-m-d H:i:s", strtotime($datePeriod->end));
                // Search For Conflicts in Dates
                $conflicts = $userLeaveRequestRep->findByAttributes([
                    [WHERE_RAW, "user_id =". $user->id.
                        " AND id <> ".$leaveRequest->id.
                        " AND status_id NOT IN (5,6,7) ".
                        " AND (" .
                        "DATE(date_from) BETWEEN '{$from}' AND '{$to}' ".
                        " OR DATE(date_to) BETWEEN '{$from}' AND '{$to}' ".
                        " OR (DATE(date_from) <= '{$datePeriod->start}' AND DATE(date_to) >= '{$datePeriod->end}')".
                        ")"
                    ]
                ]);

                // If Conflicts found Return Back And Report An Error
                if ($conflicts){
                    flash()->error('Date Conflict. Selected Period Conflicts With Other Applied Requests. Please Choose Different Period');
                    return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
                }

                // If any of the listed fields has been altered => we assume request has been modified
                if (!($leaveRequest->date_from != $from || $leaveRequest->date_to != $to || $leaveRequest->leave_id != $leaveId)){
                    flash()->error('Request Has Not Been Altered. Please Change/Modify For It To Be Reviewed.');
                    return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
                }

                // Check for Annual Leave Change
                $fromDate = \DateTime::createFromFormat('Y-m-d H:i:s', $from);
                $toDate = \DateTime::createFromFormat('Y-m-d H:i:s', $to);
                $diff = $toDate->diff($fromDate);

                $calendarDays = (int)$diff->days;
                $selectedYear = (int)$fromDate->format('Y');
                $workingDays = (int)getWorkingDays($from, $to, getHolidaysByStation($user->location->airport_id, $selectedYear));

                $maxAllowedWorkingDays = 14;
                if ($workingDays > $maxAllowedWorkingDays) {
                    flash()->error('Max Allowed Leave is 14 working days');
                    return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
                }

                // By default we consider Calendar days
                $totalApplied = $calendarDays;
                $entitlementType = CALENDAR_DAYS;

                $entitlement = $userEntitlementRepository->findByAttributes([
                    'user_id'   => $user->id,
                    'year'      => (int)$fromDate->format('Y')
                ]);

                // ONLY For Annual Leave Check
                if ($leaveRequest->leave && $leaveRequest->leave->name == ANNUAL_LEAVE) {

                    $beforeAppliedDays = $leaveRequest->days;

                    if (!$entitlement || ($entitlement && !$entitlement->entitlement)) {

                        flash()->error('Your Annual Leave Entitlement for ' . $selectedYear . ' not found. Please contact HR to resolve the issue.');
                        return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
                    }

                    $totalUsed = ($entitlement->used ? $entitlement->used : 0) + ($entitlement->pending ? $entitlement->pending : 0);
                    // Subtract currently Applied Days
                    $totalAvailable = $entitlement->entitlement;
                    $totalAvailable -= ($entitlement->used ? $entitlement->used : 0);
                    $totalAvailable -= ($entitlement->pending ? $entitlement->pending : 0); // - $beforeAppliedDays;

                    // Get Annual Leave Entitlement Type
                    $entitlementType = $entitlement->type;

                    if ($entitlementType == WORKING_DAYS) {
                        $totalApplied = $workingDays;
                    } else {
                        $totalApplied = $calendarDays;
                    }

                    $totalExceeded = $totalApplied - $totalAvailable;

//                    if ($totalExceeded > $this->leaveExceedLimit) {
                    if ($totalApplied > $totalAvailable) {
                        debug(123);
                        flash()->error('Error! You have exceeded total available entitlement days');
                        return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
                    }

                    // Entitlement only for annual leave cases
                    if ($entitlement->pending){
                        if ($entitlement->pending != $totalApplied){
                            $entitlement->pending = $entitlement->pending + $totalApplied  - $beforeAppliedDays;
                        }
                    }
                    else {
                        $entitlement->pending = $totalApplied;
                    }
//                    $entitlement->pending = $entitlement->pending ? $entitlement->pending + $totalApplied  - $beforeAppliedDays: $totalApplied - $beforeAppliedDays;
                    $entitlement->save();
                }

                // Update His Request
                $leaveRequest->date_from = $from;
                $leaveRequest->date_to = $to;
                $leaveRequest->leave_id = $leaveId;
                $leaveRequest->status_id = $status[APPLICATION_STATUS_PENDING];
                $leaveRequest->days = $totalApplied;
                $leaveRequest->exceeded_days = isset($totalExceeded) ? $totalExceeded : null;
                $leaveRequest->type = $entitlementType;
                if ($reasons){
                    $leaveRequest->reasons = $reasons;
                }
                $leaveRequest->save();

                // Mark First In Line Manager's Status As Pending
                if ($leaveStatus && count($leaveStatus)){
                    foreach ($leaveStatus as $i => &$each) {
                        // Pending for first boss and CEO
                        $each->status_id = ($i == 0 || $each->is_ceo) ? $status[APPLICATION_STATUS_PENDING] : $status[APPLICATION_STATUS_IN_LINE];
                        $each->save();
                    }
                }

                flash()->error('Request Has Been Successfully Altered And Resubmitted for Review.');
                return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
            }
            else {
                flash()->error('Something went wrong, please try again');
                return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
            }
        }
    }

    public function leaveManagerActions(IUserLeaveStatusRepository $leaveStatusRepository,
                                 IApplicationStatusRepository $applicationStatus,
                                 IUserEntitlementRepository $userEntitlementRepository){
        $leaveStatus = null;

        if (\request("leave_status_id")){
            $leaveStatus = $leaveStatusRepository->find(\request("leave_status_id"));
        }

        debug($leaveStatus);

        if (!$leaveStatus){
            return redirect()->back()
                ->withErrors(['Error! Record Not Found']);
        }

        // Get Manager
        $user = Auth::user();

        // Get Manager's Position
        $organization = $leaveStatus->organization;
        $userPosition = $organization ? $organization->position : null;

        // Get Leave Request Object
        $leaveRequest = $leaveStatus->leaveRequest;

        // Get Report To User Id
        $reportToUserId = $this->getReportToUserId($leaveStatus->report_to_user_id);

        $status = ApplicationStatus::pluck("id", "status")->all();

        $notes = \request("notes");

        if ($notes && $notes != ""){
            $previousNotes = $leaveStatus->notes;
            $notes = "-".$notes."(".baseDateFormat(date("Y-m-d H:i:s"), true).")";
            $leaveStatus->notes = $previousNotes == null || $previousNotes == "" ? $notes : $previousNotes.'<br/>'.$notes;
            $leaveStatus->reviewed_at = date("Y-m-d H:i:s");
            $leaveStatus->save();
        }

        $entitlement = $userEntitlementRepository->findByAttributes([
            'user_id' => $leaveRequest->user_id,
            'year' => date('Y', strtotime($leaveRequest->date_from))
        ]);

        $action = \request("action");

        switch ($action){
            case "approve":
                // Change To Approved
                $leaveStatus->status_id = $status[APPLICATION_STATUS_APPROVED];
                $leaveStatus->reviewed_at = date("Y-m-d H:i:s");
                $leaveStatus->save();

                foreach ($leaveRequest->leaveStatus as &$eachStatus) {
                    // Don't Touch Below Statuses
                    if ($eachStatus->line <= $leaveStatus->line)
                        continue;

                    // Next In Line Status -> PENDING
                    if ($eachStatus->line == $leaveStatus->line + 1) {
                        if ($leaveStatus->is_ceo) {// && $eachStatus->is_hr){
                            $eachStatus->status_id = $status[APPLICATION_STATUS_APPROVED]; // $status[APPLICATION_STATUS_DOCUMENTATION_COMPLETED];
                        }
                        else {
                            $eachStatus->status_id = $status[APPLICATION_STATUS_PENDING];
                        }
                    }
                    // Others IN LINE
                    else {
                        // If CEO => HR Documentation Completed
                        if ($leaveStatus->is_ceo){ // && $eachStatus->is_hr){
                            $eachStatus->status_id = $status[APPLICATION_STATUS_APPROVED]; //$status[APPLICATION_STATUS_DOCUMENTATION_COMPLETED];
                        }
                        else{
                            if ($eachStatus->is_hr){
                                $eachStatus->status_id = $status[APPLICATION_STATUS_DOCUMENTATION_IN_PROCESS];
                            }
                            else {
                                // CEO
                                if ($eachStatus->is_ceo){
                                    $eachStatus->status_id = $status[APPLICATION_STATUS_PENDING];
                                }
                                else {
                                    $eachStatus->status_id = $status[APPLICATION_STATUS_IN_LINE];
                                }
                            }
                        }
                    }
                    $eachStatus->save();
                }

                // If CEO approves it => alter used and pending fields
                if ($leaveStatus->is_ceo){
                    $this->ChangeEntitlement($leaveRequest, $entitlement, APPROVED);

                    // Update Main Request to APPROVED
                    $leaveRequest->status_id = $status[APPLICATION_STATUS_APPROVED]; //$status[APPLICATION_STATUS_DOCUMENTATION_COMPLETED];
                    $leaveRequest->save();

                    sendLeaveNotificationEmail($leaveRequest->user->email, $user, $leaveRequest, APPLICATION_STATUS_APPROVED, true);

                    // Send email to positions marked as show_leave_requests
                    try {
                        $users = getShowLeaveRequestsUser();
                        foreach ($users as $each) {
                            sendLeaveNotificationEmail($each->email, $user, $leaveRequest, APPLICATION_STATUS_APPROVED);
                        }
                    }
                    catch ( \Exception $e){
                        sendSimpleEmail($e->getMessage());
                    }
                    // End
                }
                else {
                    // Update Main Request's Status
                    $leaveRequest->status_id = $status[APPLICATION_STATUS_PENDING];
                    $leaveRequest->save();
                }
                break;

            case "decline":
                $leaveStatus->status_id = $status[APPLICATION_STATUS_DECLINED];
                $leaveStatus->reviewed_at = date("Y-m-d H:i:s");
                $leaveStatus->save();

                // Update Main Request's Status
                // Add Status As Note For Others To See
                $previousNotes = $leaveRequest->notes;
                $notes = "-".APPLICATION_STATUS_DECLINED."(".$user->first_name." ".$user->last_name;
                if ($userPosition) {
                    $notes .= "/".$userPosition->name . "/";
                }
                $notes .= ", ".baseDateFormat(date("Y-m-d H:i:s"), true).")";

                $leaveRequest->notes = $previousNotes == null || $previousNotes == "" ? $notes : $previousNotes.'<br/>'.$notes;
                $leaveRequest->save();


                foreach ($leaveRequest->leaveStatus as &$eachStatus) {
                    // Don't Touch Below Statuses
                    if ($eachStatus->line <= $leaveStatus->line) {
                        continue;
                    }

                    // CEO application status not altering to VOID
                    // CEO can Approve it
                    if (!$eachStatus->is_ceo) {
                        $eachStatus->status_id = $status[APPLICATION_STATUS_VOID];
                        $eachStatus->save();
                    }
                }

                // Update Main Request's Status
                if ($leaveStatus->is_ceo) {
                    $this->ChangeEntitlement($leaveRequest, $entitlement, DECLINED);

                    $leaveRequest->status_id = $status[APPLICATION_STATUS_DECLINED];
                    $leaveRequest->save();

                    sendLeaveNotificationEmail($leaveRequest->user->email, $user, $leaveRequest, APPLICATION_STATUS_DECLINED, true);

                    // Send email to positions marked as show_leave_requests
                    try {
                        $users = getShowLeaveRequestsUser();
                        foreach ($users as $each) {
                            sendLeaveNotificationEmail($each->email, $user, $leaveRequest, APPLICATION_STATUS_DECLINED);
                        }
                    }
                    catch ( \Exception $e){
                        sendSimpleEmail($e->getMessage());
                    }
                    // End
                }


                break;

            case "change":
                // Initially Mark Everyone's Status As In-Line
                // Only When He Changes Period THen His Reporting Manager's Position WIll Be Set to Pending
                foreach ($leaveRequest->leaveStatus as $i => &$eachStatus) {
                    if ($eachStatus->ceo){
                        $eachStatus->status_id = $status[APPLICATION_STATUS_PENDING];
                    }
                    else {
                        $eachStatus->status_id = $status[APPLICATION_STATUS_IN_LINE];
                    }
                    $eachStatus->save();
                }

                $this->ChangeEntitlement($leaveRequest, $entitlement, CHANGE);

                // Update Main Request's Status
                // Add Status As Note For Others To See
                $previousNotes = $leaveRequest->notes;
                $notes = "-".APPLICATION_STATUS_CHANGE."(".$user->first_name." ".$user->last_name;
                if ($userPosition) {
                    $notes .= "/".$userPosition->name . "/";
                }
                $notes .= ", ".baseDateFormat(date("Y-m-d H:i:s"), true).")";
                $leaveRequest->notes = $previousNotes == null || $previousNotes == "" ? $notes : $previousNotes.'<br/>'.$notes;
                $leaveRequest->status_id = $status[APPLICATION_STATUS_CHANGE];
                $leaveRequest->save();

                sendLeaveNotificationEmail($leaveRequest->user->email, $user, $leaveRequest, APPLICATION_STATUS_CHANGE, true);
                break;
        }

        return redirect()->back();
    }


    /**
     *
     * PLEASE NOT AT (*) IF USER CANCELLES AFTER APPROVAL
     * @param $leaveRequest
     * @param $entitlement
     * @param $type
     *
     */
    public function ChangeEntitlement($leaveRequest, &$entitlement, $type)
    {
        if ($leaveRequest->leave && $leaveRequest->leave->name == ANNUAL_LEAVE)
        {
            switch ($type)
            {
                case APPROVED:
                    if ($leaveRequest->days)
                    {
                        // CURRENTLY DECLINED -> (PREVIOUSLY DECLINED BY HIS BOSS)
//                        if ($leaveRequest->status->status == APPLICATION_STATUS_DECLINED){}

                        $entitlement->used = ($entitlement->used ? $entitlement->used : 0) + $leaveRequest->days;

                        if ($entitlement->pending)
                        {
                            $entitlement->pending -= $leaveRequest->days;
                        }
                    }
                    break;

                case DECLINED:
                    if ($entitlement->pending && $leaveRequest->days)
                    {
                        $entitlement->pending -= $leaveRequest->days;
                    }
                    break;

                case CANCELLED:
                    if ($leaveRequest->days) {
                        if ($leaveRequest->status && $leaveRequest->status->status == APPLICATION_STATUS_APPROVED) {//---(*)----///
                            if ($entitlement->used) {
                                $entitlement->used -= $leaveRequest->days;
                            }
                        }
                        else {
                            if ($entitlement->pending) {
                                $entitlement->pending -= $leaveRequest->days;
                            }
                        }
                    }
                    break;


                case CHANGE:
                    if ($entitlement->pending && $leaveRequest->days)
                    {
                        $entitlement->pending -= $leaveRequest->days;
                    }
                    break;
            }

            $entitlement->save();
        }
    }

    public function viewLeaveRequestDoc(Request $request, $user_leave_request)
    {
        $type = $request->get("type") ? $request->get("type") : "doc1";

        $filename = $user_leave_request->{$type};

        $url = storage_path("app/public/staff/requests/$filename");

        debug($user_leave_request);

        if ($filename && File::exists($url)) {
            $mimeType = getMimeType($filename);
            $fileContents = File::get($url);

            if ($request->has('download')){
                return response()->download($url, $filename, array('Content-Type' => $mimeType));
            }
            else {
                return response()->make($fileContents, 200,array('Content-Type' => $mimeType));
            }
        }
    }

    function uploadDocument(Request $request, $obj, $fieldName = "doc1"){
        if (!$request->file("file")){
            return;
        }

        $mimeType = $request->file('file')->getClientMimeType();
        $file =  ['file' => $request->file('file')];
        $rulesArray = ["application/pdf", "pdf", "image/jpeg", "image/jpg", "image/png", "image/gif",
            "application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
            "application/vnd.openxmlformats-officedocument.spreadsheetml.template",
            "application/vnd.ms-excel.sheet.macroEnabled.12",
            "application/vnd.ms-excel.template.macroEnabled.12",
            "application/vnd.ms-excel.addin.macroEnabled.12",
            "application/vnd.ms-excel.sheet.binary.macroEnabled.12"];

        if (in_array($mimeType, $rulesArray)){ // if ($mimeType !== 'application/pdf') {
            $fileName = $obj->id."_usr".$obj->user_id.'.' . $file['file']->getClientOriginalExtension();
            $storagePath = storage_path("app/public/staff/requests/");

            // Picture Save
            $file['file']->move($storagePath, $fileName);

            // Save in DB
            $obj->{$fieldName} = $fileName;
            $obj->save();
        }
    }

    public function leaveApply(Request $request){

        $user = Auth::user();

        $datePeriod = json_decode($request->get('date_period'));

        $status = ApplicationStatus::pluck("id", "status")->all();

        $form = new LeaveRequestForm();

        $userAP = $userStation = null;

        if ($user->id != $request->get("user_id")){
            flash()->error('Error! Leave application can only be submitted by each staff.');
            return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
        }

        if (!$user->location || !$userAP = $user->location->airport){
            flash()->error('Your station is not defined. Please input your current station and try again');
            return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
        }

        $position = getUserPosition($user);
        if (!$position){
            flash()->error('Your position is not defined. Please save your position and try again');
            return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
        }

        if ($form->isValidSaveApplyForLeave()){

            $leaveId = \request("leave_id") ? \request("leave_id") : \request("other_leave_id");

            $from = $datePeriod->start;
            $to = $datePeriod->end;

            $fromDate = \DateTime::createFromFormat('Y-m-d', $from);
            $toDate = \DateTime::createFromFormat('Y-m-d', $to);
            $diff = $toDate->diff($fromDate);

            if (strtotime($fromDate->format("Y-m-d")) > strtotime("+ 3 month")){
                flash()->error('Start date should be within 3 month period. Please choose a different period.');
                return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
            }

            $calendarDays = (int)$diff->days;
            $selectedYear = (int)$fromDate->format('Y');

            $workingDays = (int)getWorkingDays($from, $to, getHolidaysByStation($user->location->airport_id, $selectedYear));

            $maxAllowedWorkingDays = 14;
            if ($workingDays > $maxAllowedWorkingDays) {
                flash()->error('Max Allowed Leave is 14 working days');
                return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
            }


            // Search For Conflicts in Dates
            $conflicts = UserLeaveRequest::where("user_id", $user->id)
                ->whereNotIn("status_id", [5, 6, 7])
                ->where(function($sql) use ($from, $to, $datePeriod){
                    $sql->whereBetween("date_from", [$from, $to])
                        ->orWhereBetween("date_to", [$from, $to])
                        ->orWhere(function ($sql2) use ($from, $to, $datePeriod){
                            $sql2->where("date_from", "<=", $datePeriod->start)
                                ->where("date_to", ">=", $datePeriod->end);
                        });
                })
                ->first();

            // If Conflicts found Return Back And Report An Error
            if ($conflicts){
                flash()->error('Date conflict. Selected period conflicts with other applied requests. please choose different period.');
                return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
            }

            $totalExceeded = 0;

            $entitlement = UserEntitlement::where('user_id', $user->id)->where('year', $selectedYear)->first();
            // Annual Leave Case
            $totalApplied = null;
            if ($leaveId == 3) {

                debug($status);

                $pendingAnnualLeave = UserLeaveRequest::where("user_id", $user->id)
                    ->where("leave_id", $leaveId)
                    ->where("status_id", $status[APPLICATION_STATUS_PENDING])
                    ->where("date_from", ">=", $selectedYear)
                    ->first();

                if ($pendingAnnualLeave){
                    flash()->error('You already have pending annual leave request.');
                    return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
                }

                if (!$entitlement || ($entitlement && !$entitlement->entitlement)) {
                    flash()->error('Your Annual Leave Entitlement for ' . $selectedYear . ' not found. Please contact HR to resolve the issue.');
                    return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
                }

                /*
                if (blackoutDaysConflict($userStation, $from, $to, $selectedYear)){
                    flash()->error('Selected period cannot be within Black Out Date Periods of your station');
                    return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
                }
                */

                $totalUsed = ($entitlement->used ? $entitlement->used : 0) + ($entitlement->pending ? $entitlement->pending : 0);
                $totalAvailable = $entitlement->entitlement - $totalUsed;

                if ($entitlement->type == WORKING_DAYS) {
                    $totalApplied = $workingDays;
                }
                else {
                    $totalApplied = $calendarDays;
                }

                //                  2      -   3
                $totalExceeded = $totalApplied - $totalAvailable;
                if ($totalApplied > $totalAvailable) {
//                if ($totalExceeded > $this->leaveExceedLimit) {
                    flash()->error('Entitlement is exceeded by ' . $totalExceeded . ' days. Your current available entitlement is ' . $totalAvailable. ' days.');
                    return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
                }

                $entitlement->pending = $entitlement->pending ? $entitlement->pending + $totalApplied : $totalApplied;
                $entitlement->save();
            }

            // Create New Request
            $newRequest = UserLeaveRequest::create([
                'user_id'       => $user->id,
                'exceeded_days' => $totalExceeded > 0 ? $totalExceeded : null,
                'leave_id'      => $leaveId,
                'date_from'     => $datePeriod->start,
                'date_to'       => $datePeriod->end,
                'status_id'     => $status[APPLICATION_STATUS_PENDING],
                // Special Case For Annual Leave
                'type'          => $leaveId == 3 ? $entitlement->type : CALENDAR_DAYS,
                'days'          => $leaveId == 3 ? $totalApplied : $calendarDays
            ]);

            $this->uploadDocument($request, $newRequest);

            if (\request("reasons")){
                $newRequest->reasons = \request("reasons");
            }
            $newRequest->save();

            $appStatus = APPLICATION_STATUS_PENDING;

            $bosses = findReportsToPositions($user->id, $position, $user->location->airport_id);

//            debug($bosses);
            $bossesCounter = count($bosses);
            foreach ($bosses as $i => $boss) {
                $ceo = ($i + 1 == $bossesCounter);

                if ($ceo){
                    $this->createUserStatus($newRequest, $status[APPLICATION_STATUS_PENDING], $boss->id, $i, null, $ceo);
                }
                else {
                    $this->createUserStatus($newRequest, $status[$appStatus], $boss->id, $i, null, $ceo);
                    $appStatus = APPLICATION_STATUS_IN_LINE;
                }

//                debug($boss ? $boss->email : "Email empty");
                // Notification email
                if ($boss->email) {
                    sendLeaveNotificationEmail($boss->email, $user, $newRequest, APPLICATION_STATUS_PENDING, $i == 0);
                }
            }

            /*
            // Get CEO User ID
            $ceoUserId = $this->user->getCeoUserId($this->userDepartment);
            $ceoFound = false;

            // Get All Bottom Up Report To Users [His Manager => ... => CEO]
            $reportToUsers = $this->getOrganizationFromBottomToTop($id);

            $counter = count($reportToUsers);
            // Create User Leave Status
            if ($reportToUsers && $counter){
                foreach ($reportToUsers as $i => $each) {
                    $record = $userLeaveStatus->createByAttributes([
                        'request_id'        => $newRequest->id,
                        'status_id'         => $i == 0 ? $status[APPLICATION_STATUS_PENDING] : $status[APPLICATION_STATUS_IN_LINE],
                        'report_to_user_id' => $each,
                        'line'              => $i
                    ]);

                    if ($each == $ceoUserId){
                        $record->is_ceo = true;
                        $ceoFound = true;
                        $record->save();
                    }
                }
            }

            // If Last Report To User Id Exists and is Equal TO CEO User id then Skip
           if (!$ceoFound) {
                // Add CEO To Users Leave Status
                $userLeaveStatus->createByAttributes([
                    'request_id'        => $newRequest->id,
                    'status_id'         => count($reportToUsers) > 0 ? $status[APPLICATION_STATUS_IN_LINE] : $status[APPLICATION_STATUS_PENDING],
                    'report_to_user_id' => $ceoUserId,
                    'is_ceo'            => true,
                    'line'              => $counter++
                ]);
            }

            $hrManagerUserId = $this->getHrManagerUserId();

            if ($hrManagerUserId){
                // Add HR Manager To Users Leave Status
                $userLeaveStatus->createByAttributes([
                    'request_id'        => $newRequest->id,
                    'status_id'         => $status[APPLICATION_STATUS_DOCUMENTATION_IN_PROCESS],
                    'report_to_user_id' => $hrManagerUserId,
                    'is_hr'             => true,
                    'line'              => $counter
                ]);
            }
            */

            /*
            if ($userStation) {
                $stationEmail = null;

                switch ($userStation) {
                    case "BER":
                        $stationEmail = "a.bayati@gsrm.de";
                        break;

                    case "HAJ":
                        $stationEmail = "a.shah@gsrm.de";
                        break;

                    case "HAM":
                        $stationEmail = "f.fuente@gsrm.de";
                        break;

                    case "DUS":
                        $stationEmail = "s.hussein@gsrm.de";
                        break;

                    case "CGN":
                        $stationEmail = "d.kaleswarapu@gsrm.de";
                        break;

                    case "FRA":
                        $stationEmail = "f.gezer@gsrm.de";
                        break;

                    case "STR":
                        $stationEmail = "r.rizk@gsrm.de";
                        break;

                    case "MUC":
                        $stationEmail = "r.nupnau@gsrm.de";
                        break;
                }

                if ($stationEmail) {
                    $reportToUser = User::where("email", $stationEmail)->first();
                    if ($reportToUser) {
                        $this->createUserStatus($userLeaveStatus, $newRequest, $status[$appStatus], $reportToUser->id, $counter++);
                        $appStatus = APPLICATION_STATUS_IN_LINE;

                        // Notification email
                        sendLeaveNotificationEmail($reportToUser->email, $user, $newRequest, true);
                    }

                }
                else {
                    if ($user->reports_to_user_id) {
                        // First to reports to user ID
                        $this->createUserStatus($userLeaveStatus, $newRequest, $status[$appStatus], $user->reports_to_user_id, $counter++);
                        $appStatus = APPLICATION_STATUS_IN_LINE;
                    }
                }

                 // To Chris c.bedikian@gsrm.de
                $reportToUser = User::where("email", "c.bedikian@gsrm.de")->first();
                if ($reportToUser) {
                    $this->createUserStatus($userLeaveStatus, $newRequest, $status[$appStatus], $reportToUser->id, $counter++);
                    $appStatus = APPLICATION_STATUS_IN_LINE;

                    // Notification email
                    sendLeaveNotificationEmail($reportToUser->email, $user, $newRequest);
                }

                // To HR l.struckmeier@gsrm.de
                $reportToUser = User::where("email", "l.struckmeier@gsrm.de")->first();
                if ($reportToUser) {
                    $this->createUserStatus($userLeaveStatus, $newRequest, $status[$appStatus], $reportToUser->id, $counter++, true);
                    $appStatus = APPLICATION_STATUS_IN_LINE;

                    // Notification email
                    sendLeaveNotificationEmail($reportToUser->email, $user, $newRequest);
                }

                // CEO e.manzano@gsrm.de
                $reportToUser = User::where("email", "e.manzano@gsrm.de")->first();
                if ($reportToUser) {
                    $appStatus = APPLICATION_STATUS_IN_LINE;
                    $this->createUserStatus($userLeaveStatus, $newRequest, $status[$appStatus], $reportToUser->id, $counter, null, true);
                }
            }
            */

            flash()->success('Request Submitted Successfully.');

            return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
        }

        flash()->error("Please fill out all necessary fields!");

        return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit");
    }


    public function createUserStatus($newRequest, $status, $reportToUserID, $line, $hr = null, $ceo = null){
        return UserLeaveStatus::create([
            'request_id'        => $newRequest->id,
            'status_id'         => $status,
            'report_to_user_id' => $reportToUserID,
            'line'              => $line,
            'is_hr'             => $hr,
            'is_ceo'            => $ceo,
        ]);
    }


    public function getHrManagerUserId(){
        $user = $this->userDepartment->findByAttributes(['p.name' => 'HR Manager'], [], ['user_id AS id'], [
            'structure__positions AS p', 'p.id', '=', 'users__departments.position_id'
        ]);

        return $user ? $user->id : null;
    }


    /**
     * Get Report To User Ids From Bottom To Up (Employee => [Manager => ... => CEO])
     * @param $user_id
     * @return array
     */
    public function getOrganizationFromBottomToTop($user_id){
        $users = [];

        $findOrganization = $this->organization->findByAttributes(['user_id' => $user_id]);
        while($findOrganization) {
            $reportToUserId = $findOrganization->report_to_user_id;
            if ($findOrganization && $reportToUserId){
                $users[] = $reportToUserId;
            }
            $findOrganization = $this->organization->findByAttributes(['user_id' => $reportToUserId]);
        }
        return $users;
    }

    public function getReportToUserId($user_id){
        $findOrganization = $this->organization->findByAttributes(['user_id' => $user_id]);

        if ($findOrganization)
            return $findOrganization->report_to_user_id;

        return null;
    }

    /**
     * Upload Photo
     * @param $id
     * @return bool|\Symfony\Component\HttpFoundation\Response
     */
    public function upload($id)
    {
        $user = User::find($id);

        if (!$user) {
            return response()->isServerError();
        }

        $this->deletePreviousPhotos($user);

//        $src = \request("avatar_src") && \request("avatar_src") ? \request("avatar_src") : $file->getRealPath();

        $crop = new CropAvatar(\request("avatar_src"), \request("avatar_data"), $_FILES["avatar_file"], $user, 'users');

        $response = array(
            'state'     => 200,
            'message'   => $crop->getMsg(),
            'result'    => asset($crop->getResult())
        );

//        return json_encode($response);

        return redirect()->to(route("homepage")."#staff/{$id}/edit");

        /* return response()->json([
             'message'   => $crop -> getMsg(),
             'result'    => $crop -> getResult()
         ]);*/
    }

    public function delete($id)
    {
        $user = User::find($id);

        if (!$user) {
            return response()->isServerError();
        }

        $this->deletePreviousPhotos($user);

        $user->picture = null;
        $user->thumb = null;
        $user->save();

        flash()->success("Profile Photo Successfully Deleted");

        return redirect()->back();
    }

    public function deletePreviousPhotos($user){
        $picture = storage_path("app/public/users/{$user->picture}");
        $thumb = storage_path("app/public/users/{$user->thumb}");

        if (File::exists($picture)){
            File::delete($picture);
        }
        if (File::exists($thumb)){
            File::delete($thumb);
        }
    }

    public function update($id)
    {
        $inputs = request()->all();

        $user = User::find($id);

        debug($user);

        if (!$user) {
            return view('error/404');
        }

        replaceBlankAttributes($inputs);

        $this->organization->updateByAttributes(['user_id' => $id], [
            'structure_department_id'   => \request("structure_department_id"),
            'structure_position_id'     => \request("structure_position_id") ? \request("structure_position_id") : null,
        ]);

        $this->userDepartment->updateByAttributes(['user_id' => $id], [
            'department_id'   => \request("structure_department_id"),
            'position_id'     => \request("structure_position_id") ? \request("structure_position_id") : null,
        ]);

        // Check Password
        if (isset($inputs['password']) && isset($inputs['password_confirmation'])) {

            $current_password = Hash::make($inputs['current_password']);

            /*if (!isset($inputs['current_password']) || $current_password != $user->password){
                return redirect()->back()
                    ->withInput()
                    ->withErrors(['Current Password Does Not Match']);
            }*/

            if ($inputs['password'] != $inputs['password_confirmation']) {
                return redirect()->to('user/create')
                    ->withInput()
                    ->withErrors(['Password/Confirmation Do Not Match']);
            }

            $new_password = Hash::make($inputs['password']);

            $this->user->updateById($user->id, [
                'password' => $new_password
            ]);
        }

        removeUnnecessaryField($inputs, [
            '_token',
            'structure_department_id',
            'structure_position_id',
            'current_password',
            'password',
            'password_confirmation'
        ]);

        //$this->user->update($user, $inputs);

        StaffService::saveDetails($user->id);

        debug(request()->all());

        //flash()->success('Record Successfully Updated');

        return $this->edit($id);

//        return redirect()->back();
    }

    /**
     * @param ICabinCrewRepository $cabinCrew
     * @param ICaptainsFirstofficersRepository $captainFirstOfficer
     * @return $this|\Illuminate\Contracts\View\Factory|\Illuminate\Http\RedirectResponse|\Illuminate\View\View
     */
    public function register(ICabinCrewRepository $cabinCrew, ICaptainsFirstofficersRepository $captainFirstOfficer)
    {
        if ($this->isPostRequest()) {
            $validator = Validator::make(request()->all(), \User::$rules);
            if ($validator->passes()) {
                // Validation Checks Are Successfully Passed

                // Check If User Exists With Given Email
                $user = User::firstOrCreate(['email' => \request("email")]);

                User::where("id", $user->id)
                ->update([
                    'first_name' => \request("first_name"),
                    'last_name' => \request("last_name"),
                    'is_contractor' => \request("staff") ? 1 : null,
                    'password' => Hash::make(\request("password"))
                ]);

                $subdepartment_id = \request("subdepartment_id");
                $department_id = \request("department_id");
                $otherPosition = \request("other_position");

                if (\request("other_position") && \request("other_position")) {

                    $position = $this->position->firstOrCreate([
                        'department_id' => $department_id,
                        'subdepartment_id' => $subdepartment_id,
                        'title' => $otherPosition
                    ]);
                } else {
                    $position = $this->position->find(\request("position_id"));
                }

                // Check If Exists, And Create If Not

                $userDepartment = $this->userDepartment->firstOrCreate([
                    'user_id' => $user->id,
                    'department_id' => $department_id,
                    'subdepartment_id' => $subdepartment_id,
                    'position_id' => $position->id,
                ]);

                // If User is Captain/First Officer OR Purser/Cabin Crew Create Appropriate Rows

                if ($position->type == FCM_CPT_TYPE_ID) {
                    $captainFirstOfficer->firstOrCreate([
                        'user_id'       => $user->id,
                        'is_captain'    => true,
                    ]);
                }
                elseif ($position->type == FCM_FA_TYPE_ID) {
                    $captainFirstOfficer->firstOrCreate([
                        'user_id'       => $user->id,
                        'is_captain'    => null
                    ]);
                }
                else if ($position->type == CCM_PSR_TYPE_ID) {
                    $cabinCrew->firstOrCreate([
                        'user_id'   => $user->id,
                        'is_purser' => true
                    ]);
                }
                else if ($position->type == CCM_CC_TYPE_ID) {
                    $cabinCrew->firstOrCreate([
                        'user_id'   => $user->id,
                        'is_purser' => null
                    ]);
                }

                return redirect()->route('user/login')
                    ->with('message', 'Thanks for registering!');
            } else {
                // validator has failed, display error messages
                return redirect()->route('user/register')
                    ->with('message', 'The following errors occurred')
                    ->withErrors($validator)
                    ->withInput();
            }
        }

        return view('user/register', [
            "structure__departments" => ["" => "Select Department"] + Department::pluck("name", "id")->all(),
            "staff" => [AIRLINE_NAME . " Staff", 1 => 'Contractor']
        ]);
    }

    /**
     * User Profile Of Everyone
     * @return mixed
     */
    public function profile()
    {
        $userId = \request("id");
        $user = $this->user->getUserFullInformation($userId);
        $department = $user->department_id ? $this->department->find($user->department_id) : false;
        //$subDepartment = $user->subdepartment_id ? $this->subDepartment->find($user->subdepartment_id) : false;
        $position = $user->position_id ? $this->position->find($user->position_id) : false;
        return view("user/profile", [
            "department" => $department ? $department->name : false,
//            "subdepartment"  => $subDepartment ? $subDepartment->name : false,
            "position" => $position ? $position->title : false,
            "user" => $user
        ]);
    }


    /**
     * Get AJAX user image
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAjaxgetuserimage()
    {
        $userId = (int)\request("user_id");

        $user = User::find($userId);
        if ($user) {
            $picture = asset("/assets/img/profile_picture.png");
            if ($user->picture) {
                $picture = asset("storage/users/" . $user->picture);
            }
            return response()->json([
                "image" => $picture,
                "success" => TRUE
            ]);
        } else {
            return response()->json([
                "error" => TRUE,
                "message" => "Not found user by given ID"
            ]);
        }
    }


    /**
     * Get validator for login page
     * @return mixed
     */
    protected function getLoginValidator()
    {
        return Validator::make(request()->all(), [
            "email" => "required|email",
            "password" => "required"
        ]);
    }

    /**
     * Get login credentials
     * @return array
     */
    protected function getLoginCredentials()
    {

        return [
            "email" => \request("email"),
            "password" => \request("password")
        ];

    }

    /**
     * Reset password
     * @param $credentials
     * @return mixed
     */
    protected function resetPassword($credentials)
    {
        return Password::reset($credentials, function ($user, $pass) {
            $user->password = Hash::make($pass);
            $user->save();
        });
    }

    /**
     * Send reminder to user with reset password link
     * @return mixed
     */
    protected function getPasswordRemindResponse()
    {
        return Password::remind(\request()->only("email"));
    }

    /**
     * Check is valid user for reset password
     * @param $response
     * @return bool
     */
    protected function isInvalidUser($response)
    {
        return $response === Password::INVALID_USER;
    }


}
