<?php

namespace App\Http\Controllers;

use App\Classes\ULD\StockControl;
use App\Models\Airline;
use App\Models\Airport;
use App\Models\Container;
use App\Models\ContainerType;
use App\Models\Flight;
use App\Models\FlightContainer;
use App\Models\FlightContainerInfo;
use App\Models\FlightNumber;
use App\Models\FlightSector;
use App\Models\StaffAirline;
use App\Models\StaffStation;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;

class ULDController extends Controller
{
    const MAX_EXECUTION_TIME = 180;

    public function index(Request $request)
    {
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '512M');

        // Get Staff Handling AP and Airlines
        list($handlingAirlines, $handlingAirports) = getStaffHandlingAirports();

        $selectedAirline = $request->get("airline");
        $selectedAirports = $request->has("airport") ? $request->get("airport") : array_keys($handlingAirports);

        if (count($request->all())) {

            if ($request->get("uldNum") && $selectedAirline){
                $container = Container::where("num", $request->get("uldNum"))
                                        ->where("airline_id", $selectedAirline);

                if ($request->get("uldType")){
                    $container->whereIn("container_type_id", $request->get("uldType"));
                }

                $container = $container->get();

                if ($container->count() == 1){
                    return redirect()->to("uld-report/{$container->first()->id}?dateSearch=all");
                }
            }

            $flights = Flight::FlightsRangeConditional($selectedAirports, $selectedAirline, $request->get("type"));

            if ($flights && $flights->count()) {

                $flightIDs = $flights->pluck("id")->all();

                $data = FlightContainerInfo::getAll($flightIDs, $request->get("uldType"), $request->get("uldNum"));
            }

            if ($selectedAirports && !is_array($selectedAirports)){
                try {
                    $stockControl = new StockControl($selectedAirline, $selectedAirports, $request->get("datetime"));
                    $stockControl->setULDTypes($request->get("uldType"));
                    $stockControl->process();
                }
                catch(\Exception $e){
                    debug($e->getMessage());
                }
            }
        }

        $this->viewData = [
            'dateYesterday'     => date('Y-m-d',strtotime(" - 1 days")),
            "airlines"          => $handlingAirlines,
            "airports"          => $handlingAirports,
            "flightNumbers"     => FlightNumber::getArrayFlightNumbersWithSector(false, false, false, null, true),
            'sectors'           => FlightSector::listSectors(),
            'sectorsByAirlines' => FlightSector::getSectorsByAirlines(),
            'monthNames'        => getMonthsArray(),
            'years'             => getYearsArray(),
            'handlingStations'  => Airport::getHandlingStationsIdAndObject(),
            "data"              => isset($data) ? $data : [],
            "stockULDs"         => isset($stockControl) ? $stockControl->stockULDs : [],
            "stockULDsByType"   => isset($stockControl) ? $stockControl->stockULDsByType : [],
            "uldTypes"          => ContainerType::pluck("name", "id")->all(),
        ];

        return view("uld-report.index", $this->viewData);
    }


    public function show(Request $request, $container)
    {
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        $handlingAirports = StaffStation::currentStaffStationsList(IATA);

        if (!count($handlingAirports)){
            $handlingAirports = Airport::listHandlingStations();
        }

        $selectedAirports = $request->has("airport") ? $request->get("airport") : array_keys($handlingAirports);

        $flights = Flight::FlightsRangeConditional($selectedAirports, $container->airline_id, $request->get("type") ? $request->get("type") : ALL);

        if ($flights && count($flights)) {

            $flightIDs = $flights->pluck("id")->all();

            $data = FlightContainer::getAllByContainer($flightIDs, $container->id);

            debug($data);
        }

        $this->viewData = [
            'dateYesterday'     => date('Y-m-d',strtotime(" - 1 days")),
            "airports"          => $handlingAirports,
            "flightNumbers"     => FlightNumber::getArrayFlightNumbersWithSector(false, false, false, null, true),
            'sectors'           => FlightSector::listSectors(),
            'sectorsByAirlines' => FlightSector::getSectorsByAirlines(),
            'monthNames'        => getMonthsArray(),
            'years'             => getYearsArray(),
            'handlingStations'  => Airport::getHandlingStationsIdAndObject(),
            "data"              => isset($data) ? $data : [],
        ];

        return view("uld-report.show", $this->viewData);

    }

    public function search(Request $request)
    {
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        $handlingAirlines = [];

        if (ghaModule()) {
            $handlingAirlines = StaffAirline::currentStaffAirlinesList(NAME);

            if (!count($handlingAirlines)) {
                $handlingAirlines = Airline::listHandlingAirlines();
            }
        }


        $selectedAirline = $request->get("airline");

        $containers = [];

        if (count($request->all())) {

            $containers = Container::select();

            if ($request->get("uldType")) {
                $containers->whereIn("container_type_id", $request->get("uldType"));
            }

            if ($selectedAirline) {
                $containers->where("airline_id", is_array($selectedAirline) ? $selectedAirline : [$selectedAirline]);
            }

            // Lesser strict mode
            $containersMode2 = clone $containers;

            // Get
            $containers = $containers->where("num", $request->get("uldNum"))
                                      ->get();

            debug($containers);

            if ($containers->count() == 1) {
                return redirect()->to("uld-report/{$containers->first()->id}?dateSearch=all");
            }

            // Not found in strict mode
            if (!$containers->count()){

                $containers = $containersMode2->where("num", "LIKE", $request->get("uldNum")."%")
                                              ->get();

                if ($containers->count() == 1) {
                    return redirect()->to("uld-report/{$containers->first()->id}?dateSearch=all");
                }
            }
        }

        debug($containers);

        $this->viewData = [
            "airlines"          => $handlingAirlines,
            "containers"        => $containers,
            "uldTypes"          => ContainerType::pluck("name", "id")->all(),

        ];

        return view("uld-report.search", $this->viewData);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }




    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
