<?php

namespace App\Http\Controllers;

use App\Classes\Parsing\Parse;
use App\Classes\Parsing\ParseMessagesOperations;
use App\Classes\Parsing\ParseOperations;
use App\Models\FlightMessage;
use App\Models\LDMmessage;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;


class TestController extends Controller
{

    protected $info = "";
    protected $error = "";

    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function messages(Request $request)
    {
        $result = $request->get("result");

//        $message = LDMmessage::find(60)->email_body;

        $this->viewData = [
            'message'       => isset($message) ? $message : null,
            'result'        => $result
        ];

        return view("test/messages", $this->viewData);
    }

    public function checkMessages(Request $request){
        $message = $request->get("message");
        $month = $request->get("month");

        debug($request->all());

        $month = $month < 10 ? "0".$month : $month;
        $skipDateRangeCheck = $request->exists("skip_date_range_check");
        $date = date("Y-{$month}-d");

        //$parseOperations = new ParseOperations($date, null, null, null, $skipDateRangeCheck);
        //$parseOperations->run($message);
        debug($message);
        debug("INIT GIVEN DATE: $date");
        debug("INIT MONTH : $month");
        $result = parseMessage($message, $date, $skipDateRangeCheck);
        debug($result);

        return 1;
    }

    public function parseAgain(Request $request, $type){
        $date = $request->get("date") ? $request->get("date") : date("Y-m-d", strtotime("yesterday"));

        return parseMessageOperation(strtoupper($type), $date);
    }

    public function parseSingleMessage(Request $request, $type, $id){
        $MAX_EXECUTION_TIME = 60;

        ini_set("max_execution_time", $MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        debug($type);
        debug($id);

        $parseOperations = new \App\Classes\Parsing\ParseMessagesOperations(null,null,null,null,true);
        $result = $parseOperations->runSingle(strtoupper($type), $id);

        if ($result && array_key_exists("parsed", $result)){
            return $result["parsed"];
        }
    }

    /**
     * @param Request $request
     * @return $this
     */


    public function flightsMessages(Request $request){

        $flightID = $request->get("flight_id") ? $request->get("flight_id") : 70407;

        $flightMessages1 = FlightMessage::where("flight_id", $flightID)
            ->get();

        $flightMessages2 = FlightMessage::where("flight_id", $flightID)
            ->get([
                "message_type"
            ]);

        $flightMessages3 = FlightMessage::where("flight_id", $flightID)
            ->groupBy(["flight_id", "message_type"])
            ->get([
                "message_type"
            ]);

        debug($flightMessages1);
        debug($flightMessages2);
        debug($flightMessages3);

        return 1;
    }

    public function phpInfo(){
        return phpinfo();
    }

}
