<?php namespace App\Http\Controllers;

use App\Models\AircraftType;
use App\Models\Airline;
use App\Models\Airport;
use App\Models\CaptainFirstOfficer;
use App\Models\Department;
use App\Models\EmailNotification;
use App\Models\FlightRoute;
use App\Models\FlightType;
use App\Models\Location;
use App\Models\MaritalStatus;
use App\Models\Position;
use App\Models\Region;
use App\Models\SubDepartment;
use App\Models\User;
use App\Repositories\IataTermsRepository;
use App\Repositories\Interfaces\IAirlineRepository;
use App\Repositories\Interfaces\IAirportRepository;
use App\Repositories\Interfaces\IBaggageBrandRepository;
use App\Repositories\Interfaces\IDepartmentRepository;
use App\Repositories\Interfaces\IIndicatorCategoryRepository;
use App\Repositories\Interfaces\IIndicatorRepository;
use App\Repositories\Interfaces\IOrganizationLevelRepository;
use App\Repositories\Interfaces\IOrganizationRepository;
use App\Repositories\Interfaces\IPassengerRepository;
use App\Repositories\Interfaces\IPositionRepository;
use App\Repositories\Interfaces\IRevenueTargetPeriodRepository;
use App\Repositories\Interfaces\IRevenueTargetRepository;
use App\Repositories\Interfaces\IUserDepartmentRepository;
use App\Repositories\Interfaces\IUserIndicatorDetailRepository;
use App\Repositories\Interfaces\IUserIndicatorRepository;
use App\Repositories\Interfaces\IUserRepository;
use App\Repositories\Interfaces\IWBIncomeLevelRepository;
use App\Repositories\Interfaces\IWBRegionRepository;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

use App\Models\Country;
use App\Models\City;
use App\Models\Nationality;
use App\Models\Language;
use Illuminate\Support\Facades\Session;
use OwenIt\Auditing\Audit;

class TemplateController extends Controller {


    public function getAjaxGetButtons(){
        return view('general/buttons');
    }

    public function getPopulation(){
        $population = DB::table("population2")->get();

        foreach ($population as $each) {
            $city = ucwords(strtolower($each->city));
            $matchCity = City::where('city', $city)->first();

            $population = $each->population;
            if ($matchCity){
                $matchCity->population = $population;

                if (!$matchCity->country){
                    $country = Country::where('country', $each->country)->first();
                    $matchCity->country_id = $country->id;
                }
                $matchCity->save();
            }
            else {
                $newCity = new City();
                $newCity->city = $city;
                $newCity->population = $population;
                $newCity->source_year = 2005;
                $country = Country::where('country', $each->country)->first();
                if ($country){
                    $newCity->country_id = $country->id;
                }
                $newCity->save();
            }
        }

        return 123;
    }

    public function getAjaxOrganizationInfo(){
        $organizationLevelId = \request("organization_level_id");
        $list = [];
        debug(request()->all());
        if ($organizationLevelId) {
            $tables = $this->organizationLevel->getRelatedTableNames($organizationLevelId);
            $multiple_selection = $this->organizationLevel->getAttributeById($organizationLevelId, 'multiple_selection');
            foreach ($tables as $each) {
                switch ($each) {
                    case contains($each, 'divisions'):
                        $list['divisions'] = [
                            'data'      => $this->division->listModelVariable(['division', 'id'], !$multiple_selection),
                            'multiple'  => $multiple_selection
                        ];
                        break;
                    case contains($each, 'regions'):
                        $list['regions'] = [
                            'data'      => $this->region->listModelVariable(['region', 'id'], !$multiple_selection),
                            'multiple'  => $multiple_selection
                        ];
                        break;
                    case contains($each, 'countries'):
                        $list['countries'] = [
                            'data'      => $this->country->listModelVariable(['country', 'id'], !$multiple_selection),
                            'multiple'  => $multiple_selection,
                            'search'    => true
                        ];
                        break;
                    case contains($each, 'cities'):
                        $list['cities'] = [
                            'data'      => $this->city->listModelVariable(['city', 'id'], !$multiple_selection),
                            'multiple'  => $multiple_selection,
                            'search'     => true
                        ];
                        break;
                    case contains($each, 'agency'):
                        $list['agency'] = [
                            'data'      => $this->agency->listModelVariable(['agency', 'id'], !$multiple_selection),
                            'multiple'  => $multiple_selection,
                            'search'    => true
                        ];
                        break;
                    case contains($each, 'passengers'):
                        $list['passengers'] = [
                            'data'      => $this->passenger->listModelVariable([ ['first_name', 'last_name'], 'id', ' '], !$multiple_selection),
                            'multiple'  => $multiple_selection,
                            'search'    => true
                        ];
                        break;
                }
            }

            $container_class = \request("container_class") ? \request("container_class") : 'col-lg-12';
            $sub_container_first = \request("sub_container_first") ? \request("sub_container_first") : 'col-md-3';
            $sub_container_second = \request("sub_container_second") ? \request("sub_container_second") : 'col-md-3';

            return view('template/select-with-label', ['list' => $list, 'additional_class' => 'related_tables',
                'container_class' => $container_class,
                'sub_container_first' => $sub_container_first,
                'sub_container_second' => $sub_container_second]);

        }
    }

    public function getAjaxSelectWithLabel(){
        $list = \request("list");
        return view('template/select-with-label', ['list' => $list]);
    }

    public function getAjaxLevelsByDepartmentId(){
        $department_id  = \request("department_id");
        $label          = \request("label");
        $name           = \request("name");

        $data = $this->organizationLevel->findAndListModelVariable(['structure_department_id' => $department_id], [['level','name'], 'id', '-'], true);

        $list[$name] = [
            'data'      => $data,
            'multiple'  => false,
            'search'    => false,
            'label'     => $label
        ];

        $container_class = \request("container_class") ? \request("container_class") : 'col-lg-12';
        $sub_container_first = \request("sub_container_first") ? \request("sub_container_first") : 'col-md-3';
        $sub_container_second = \request("sub_container_second") ? \request("sub_container_second") : 'col-md-3';

        return view('template/select-with-label', ['list' => $list,
            'container_class' => $container_class,
            'sub_container_first' => $sub_container_first,
            'sub_container_second' => $sub_container_second]);

    }

    public function getAjaxRevenueTargetPeriodById(IRevenueTargetPeriodRepository $periodRepository){
        $id = \request("id");

        $period = $periodRepository->find($id);

        if ($period){

        }
    }

    public function getAjaxUsersByOrganizationLevelId(IRevenueTargetRepository $revenueTarget){
        $organization_level_id = \request("organization_level_id");
        $period_id = \request("period_id");
        $searchable = \request("searchable") ? \request("searchable") : true;
        $accountable_staff = \request("accountable_staff") ? true : false;
        $required = \request("required") ? \request("required") : false;
        // Lists Organization Ids of Employees instead of User Ids
        $organization_ids = \request("organization_ids") ? true : false;
        $upper_level_exists = \request("upper_level_exists") ? true : false;
        $label = \request("label") ? \request("label") : 'Reports To';
        $select_name = \request("select_name") ? \request("select_name") : 'report_to_user_id';

        $container_class = \request("container_class") ? \request("container_class") : 'col-lg-12';
        $sub_container_first = \request("sub_container_first") ? \request("sub_container_first") : 'col-md-3';
        $sub_container_second = \request("sub_container_second") ? \request("sub_container_second") : 'col-md-3';

        $search_attr = ['organization_level_id' => $organization_level_id];
        if ($accountable_staff){
            $search_attr['support_staff'] = 0;
        }
        $organization = $this->organization->findAllByAttributes($search_attr, ['user', 'position']);

        if ($organization) {
            $users = [];
            foreach ($organization as $each) {
                $user = $each->user;
                if ($organization_ids)
                    $users[$each->id] = $user->first_name." ".$user->last_name. '/' . $each->position->name . '/';
                else
                    $users[$user->id] = $user->first_name." ".$user->last_name. '/' . $each->position->name . '/';
            }

            if ($upper_level_exists) {
                $level = $this->organizationLevel->find($organization_level_id);
                $level = $level ? $level->level : false;
                if (!$period_id){
                    return response()->json([
                        'success' => false,
                        'message' => "Please Select Period First"
                    ]);
                }
                if ($level && $level > 1){
                    $upper_level = $level - 1;
                    $search = $revenueTarget->findByAttributes([
                        'level'     => $upper_level,
                        'period_id' => $period_id
                    ], [], [], [
                        ['organization', 'organization.id', '=', 'revenue__targets.organization_id'],
                        ['organization__level', 'organization__level.id', '=', 'organization.organization_level_id'],

                    ]);
                    debug($search);

                    if (!$search){
                        return response()->json([
                            'success' => false,
                            'message' => "Revenue Targets For Level {$upper_level} Does Not Exists. Please First Create Revenue Targets For Upper Level"
                        ]);
                    }
                }
            }

            $list[$select_name] = [
                'data'      => $users,
                'multiple'  => false,
                'search'    => $searchable,
                'label'     => $label,
                'required'  => $required
            ];

            debug($list);

            return view('template/select-with-label', ['list' => $list,
                                                        'container_class' => $container_class,
                                                        'sub_container_first' => $sub_container_first,
                                                        'sub_container_second' => $sub_container_second
                                                        ]);
        }
    }

    public function getAjaxUsersByDepartmentId(IOrganizationRepository $organization){
        $departmentId = \request("department_id");
        $usersList = $organization->listNotAssignedUsers(['department_id' => $departmentId], TRUE);

        if ($usersList) {
            foreach ($usersList as $id => $full_name) {
               $users[$id] = $full_name;
            }
            if (!isset($users))
                return response()->json([
                    'success'   => false,
                    'message'   => 'Not Found Any Employees At This Department'
                ]);

            $list['user_id'] = [
                'data'      => $users,
                'multiple'  => false,
                'search'    => true,
                'label'     => 'Employee'
            ];

            $container_class = \request("container_class") ? \request("container_class") : 'col-lg-12';
            $sub_container_first = \request("sub_container_first") ? \request("sub_container_first") : 'col-md-3';
            $sub_container_second = \request("sub_container_second") ? \request("sub_container_second") : 'col-md-3';

            return view('template/select-with-label', [
                'list' => $list,
                'container_class' => $container_class,
                'sub_container_first' => $sub_container_first,
                'sub_container_second' => $sub_container_second
            ]);
        }
    }

    public function getAjaxModelAutocomplete(IataTermsRepository $iataTerms){

        $type = \request("type");
        $terms_start_with = \request("name_starts_with");

        $name = strtoupper($terms_start_with);
        switch($type){
            case 'iata_terms':
                $list = $iataTerms->findAndListModelVariable(['term' => ['LIKE', "$name%"]], ['term'], false, 10);

        }
        return json_encode($list);
    }

    public function getAjaxAirportsAutocomplete(IAirportRepository $airportRepository){
        $iata = \request("iata");
        $list = $airportRepository->findAndListModelVariable(['iata' => ['LIKE', "$iata%"]], ['iata'], false, 10);
        return json_encode($list);
    }

    public function getAjaxAirlinesAutocomplete(IAirlineRepository $airlineRepository){
        $airline = \request("airline");
        $list = $airlineRepository->findAndListModelVariable(['iata' => ['LIKE', "$airline%"]], ['iata'], false, 10);
        return json_encode($list);
    }

    public function getAjaxBaggageBrandsAutocomplete(IBaggageBrandRepository $baggageBrandRepository){
        $search = \request("search");
        $list = $baggageBrandRepository->findAndListModelVariable(['name' => ['LIKE', "$search%"]], ['name'], false, 10);
        return json_encode($list);
    }

    public function getAjaxAddIndicatorsQuery(IIndicatorRepository $indicator,
                                              IIndicatorCategoryRepository $indicatorCategory,
                                              IUserIndicatorRepository $userIndicator,
                                              IUserIndicatorDetailRepository $userIndicatorDetail,
                                              IWBIncomeLevelRepository $incomeLevel,
                                              IWBRegionRepository $region){
        $currentUrl = \request("currentUrl");
        $incomeLevels = \request("incomeLevels");
        $regions = \request("regions");
        $countries = \request("countries");
        $categoryId = \request("category") ? \request("category") : null;
        $indicatorId = \request("indicator_id");
        $periodFrom = \request("periodFrom") ? \request("periodFrom") : null;
        $periodTo = \request("periodTo") ? \request("periodTo") : null;
        $userId = $this->authObject->user()->id;

        debug(request()->all());

        $newIndicator = $userIndicator->createByAttributes([
            'user_id'                   => $userId,
            'indicator_id'              => $indicatorId,
            'indicator_category_id'     => $categoryId,
            'period_from'               => $periodFrom,
            'period_to'                 => $periodTo
        ]);

        if ($newIndicator) {

            $data['indicator_id'] = $indicator->find($indicatorId)->indicator_name;
            $data['category'] = $categoryId ? $indicatorCategory->find($categoryId)->category : '';
            $data['periodFrom'] = $periodFrom;
            $data['periodTo'] = $periodTo;

            // Generate Url
            $data['url'] = $currentUrl."?user_indicator_id={$newIndicator->id}".
                                 "&indicator_id={$indicatorId}";
            if ($categoryId) {
                $data['url'] .= "&category={$categoryId}";
            }
            if ($periodFrom) {
                $data['url'] .= "&periodFrom={$periodFrom}";
            }
            if ($periodTo) {
                $data['url'] .= "&periodTo={$periodTo}";
            }

            if ($incomeLevels) {
                foreach ($incomeLevels as $each) {
                    $itemLevel = $incomeLevel->findByAttributes(['code' => $each]);
                    if ($itemLevel) {
                        $userIndicatorDetail->createByAttributes([
                            'user_indicator_id' => $newIndicator->id,
                            'wb_income_level_id' => $itemLevel->id
                        ]);
                        $data['incomeLevels'][] = $itemLevel->name;
                        $data['url'] .= "&incomeLevels[]={$itemLevel->id}";

                    }
                }
            } elseif ($regions) {
                foreach ($regions as $each) {
                    $itemRegion = $region->findByAttributes(['code' => $each]);
                    if ($itemRegion) {
                        $userIndicatorDetail->createByAttributes([
                            'user_indicator_id' => $newIndicator->id,
                            'wb_region_id' => $itemRegion->id
                        ]);
                        $data['regions'][] = $itemRegion->name;
                        $data['url'] .= "&regions[]={$itemRegion->id}";
                    }
                }
            }
            foreach ($countries as $each) {
                $itemCountry = $this->country->find($each);
                if ($itemCountry) {
                    $userIndicatorDetail->createByAttributes([
                        'user_indicator_id'  => $newIndicator->id,
                        'country_id'         => $itemCountry->id
                    ]);
                    $data['countries'][] = $itemCountry->country;
                    $data['url'] .= "&countries[]={$each}";
                }
            }

        }
        debug($data);

        return view('template/widget-list-item', ['data' => $data]);
    }

    public function getAjaxPassengerPicture(IPassengerRepository $passengerRepository)
    {
        $id = (int)\request("passenger_id");

        $passenger = $passengerRepository->find($id);

        if ($passenger) {
            $picture = asset("/assets/img/profile_picture.png");
            if ($passenger->picture) {
                $picture = asset("/assets/img/passengers/" . $passenger->picture);
            }
            return view('template/user-popup-info', ['picture' => $picture]);
        } else {
            return response()->json([
                "error" => TRUE,
                "message" => "Not found user by given ID"
            ]);
        }
    }

    public function getAjaxCountriesByIncomeLevelOrRegionId(){
        $selectedIds = \request("selected_ids");
        $type = \request("type");
        $additional_class = \request("additional_class");

        $selectedIds = implode(';', $selectedIds);
        $jsonUrl = "http://api.worldbank.org/country?per_page=1000&{$type}={$selectedIds}&format=json";

        debug($jsonUrl);
        $data = json_decode(file_get_contents($jsonUrl));
        debug($data);
        if (!isset($data[1])) {
            return response()->json([
                'success' => false,
                'message' => 'Not Found Any Employees At This Department'
            ]);
        }

        foreach ($data[1] as $each) {
            $countryList[] = $each->iso2Code;
        }

        $countryList = array_unique($countryList);

        debug(count($countryList));

        $countryList = $this->country->findAndListModelVariable(['abbr' => ['IN', $countryList]],['country', 'id']);

        debug($countryList);

        $list['countries'] = [
            'data'      => $countryList,
            'multiple'  => true,
            'search'    => true,
            'label'     => 'Countries'
        ];

        return view('template/select-with-label-2', ['list' => $list, 'additional_class' => $additional_class]);
    }

    public function getAjaxIndicatorsByCategoryId(IIndicatorRepository $indicator){
        $category_id = \request("category_id");
        $additional_class = \request("additional_class");
        $indicators = $indicator->findAndListModelVariable(['category_id' => $category_id], ['indicator_name', 'id']);

        if (!$indicators) {
            return response()->json([
                'success' => false,
                'message' => 'Not Found Any Employees At This Department'
            ]);
        }

        $list['indicator_id'] = [
            'data'      => $indicators,
            'multiple'  => false,
            'search'    => true,
            'label'     => 'Indicator'
        ];

        return view('template/select-with-label-2', ['list' => $list, 'additional_class' => $additional_class]);
    }

    public function getAjaxPositionsByDepartmentId(IPositionRepository $position){
        $department_id = \request("department_id");
        $additional_class = \request("additional_class");
        $positions = $position->findAllByAttributes(['department_id' => $department_id]);

        if ($positions) {
            $positionList = [];
            foreach ($positions as $each) {
                $positionList[$each->id] = $each->name;
            }
            if (!isset($positionList))
                return response()->json([
                    'success'   => false,
                    'message'   => 'Not Found Any Employees At This Department'
                ]);

            $list['structure_position_id'] = [
                'data'      => $positionList,
                'multiple'  => false,
                'search'    => true,
                'label'     => 'Position'
            ];

            $container_class = \request("container_class") ? \request("container_class") : 'col-lg-12';
            $sub_container_first = \request("sub_container_first") ? \request("sub_container_first") : 'col-md-3';
            $sub_container_second = \request("sub_container_second") ? \request("sub_container_second") : 'col-md-3';

            return view('template/select-with-label', ['list' => $list, 'additional_class' => $additional_class,
                'container_class' => $container_class,
                'sub_container_first' => $sub_container_first,
                'sub_container_second' => $sub_container_second]);
        }
    }

    /**
	 * Load Template Input/Select/CheckBox/...
	 * @return Response
	 */
	public function getAjaxGetEditableFields()
	{
        $class = \request("class") ? \request("class") : '';
        $input_char_max = \request("input_char_max") ? \request("input_char_max") : '';
        $type = \request("type");
        $field = \request("field");
        $values = null;
        switch ($type){
            case 'textarea':
                $url = 'textarea-with-buttons';
                break;
            case 'checklist':
                $url = 'checkbox-with-buttons';
                break;
            case 'text':
                $url = 'input-with-buttons';
                break;
            case 'date':
                $url = 'input-with-buttons';
                break;
            case 'time':
                $url = 'input-with-buttons';
                break;
            case 'select':
                // Get All Selectable Values Depending on Field
                $values = $this->getSelectValues($field);
                $url = 'select-with-buttons';
                break;
            case 'multiselect':
                // Get All Selectable Values Depending on Field
                $values = $this->getMultiSelectValues($field);
                $url = 'multiselect-with-buttons';
                break;
        }

		return view("template/$url", compact(['values', 'class', 'input_char_max']));
	}


    /**
     * @return \Illuminate\View\View
     */

    public function getAjaxSessionFlashMessage(){
        debug(Session::all());
        return view('vendor/flash/message');
    }
    /**
     * Get Modal Loading
     * @return \Illuminate\View\View
     */
    public function getAjaxModalLoading(){
        $text = \request("text") ? \request("text") : 'Please Wait';
        return view('template/modal-loading', compact('text'));
    }


    /**
     * Universal Save Record
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAjaxSaveEditableFields(Guard $auth)
	{
        $model       = \request("model");
        $field       = \request("field");
        $value       = \request("value");
        $field_value = \request("field_value");
        $id          = \request("id");
        $foreign_key = \request("foreign_key");
        $value_key   = \request("value_key");

        $message = 'Data Successfully Saved';
        $success = true;

        if ($foreign_key) {
            // Has Predefined Field Value
            if ($field_value){
                if (is_array($value)) {
                    foreach ($value as $each) {
                        $attribute = [$foreign_key => $id, $field => $each];
                        // Check If Exists, And Create If Not
                        $record = call_user_func("App\\Models\\{$model}::firstOrCreate", $attribute);
                        // Set Created And Updated By Fields If Not Set
                        setCreatedUpdatedBy($record, $auth);
                    }
                } else {
                    $attribute = [$foreign_key => $id, $field => $field_value];
                    // Check If Exists, And Create If Not
                    $record = call_user_func("App\\Models\\{$model}::firstOrCreate", $attribute);
                    $record->{$value_key} = $value;
                    $record->save();
                }
            }
            else {
                if (!$value){
                    // Add Models That have only 1 value
                    if (in_array($model, ["CaptainFirstOfficer", "CabinCrew"])){
                        $record = call_user_func("App\\Models\\{$model}::where", [$foreign_key => $id]);
                        $record->update([$field => null]);
                    }
                    else {
                        $record = call_user_func("App\\Models\\{$model}::where", [$foreign_key => $id]);
                        try {
                            $record->update([
                                "deleted_at" => date("Y-m-d H:i:s"),
                                "updated_by" => Auth::user()->id,
                            ]);
                        }
                        catch (\Exception $e){
                            $record = $record->get();
                            // Audit Deleted
                            auditDeleted($record);
//                            $record->delete();
                        }
                    }
                }
                else {
                    if (is_array($value)) {
                        foreach ($value as $each) {
                            $attribute = [
                                $foreign_key    => $id,
                                $field          => $each
                            ];
                            // Check If Exists, And Create If Not
                            $record = call_user_func("App\\Models\\{$model}::firstOrCreate", $attribute);
                            // Set Created And Updated By Fields If Not Set
                            setCreatedUpdatedBy($record, $auth);
                        }
                        $record = call_user_func("App\\Models\\{$model}::where", [$foreign_key => $id]);
                        $record->whereNotIn($field, $value);
                        try {
                            $record->update([
                                "deleted_at" => date("Y-m-d H:i:s"),
                                "updated_by" => Auth::user()->id,
                            ]);
                        }
                        catch (\Exception $e){
                            $record = $record->get();

                            // Audit Deleted
                            auditDeleted($record);
//                            $record->delete();
                        }

                    } else {
                        $attribute = [$foreign_key => $id];
                        // Check If Exists, And Create If Not
                        $record = call_user_func("App\\Models\\{$model}::firstOrCreate", $attribute);
                        $record->{$field} = ($value || (is_numeric($value) && (int)$value === 0)) ? $value : null;
                        $record->save();
                    }
                }
            }
        }
        else {
            $record = call_user_func("App\\Models\\{$model}::find", $id);
            if ($record) {
                if ($value && is_array($value)){
                    $record->{$field} = implode(";", $value);
                }
                else {
                    $record->{$field} = ($value || (is_numeric($value) && (int)$value === 0)) ? $value : null;
                }

                try {
                    $record->save();
                }
                catch (\Exception $e){
                    $success = false;
                    $message = "Error! Duplicate entry.";
                }
            }
        }

		return response()->json([
            'success' => $success,
            'type'    => $success ? 'success' : 'danger',
            'message' => $message
        ]);
	}

    protected function getMultiSelectValues($field){
        $list = [];
        switch ($field){
            case contains($field, 'off_days'):
                $list = [
                    1 => "Monday",
                    2 => "Tuesday",
                    3 => "Wednesday",
                    4 => "Thursday",
                    5 => "Friday",
                    6 => "Saturday",
                    0 => "Sunday",
                ];
                break;
            case contains($field, 'airline_id'):
                $list = Airline::listHandlingAirlinesWithCode('iata', 'id');
                break;
            case contains($field, 'airport_id'):
                $list = Airport::listHandlingAirportsWithCode('iata', 'id');
                break;
            case contains($field, 'route_id'):
                $list = FlightRoute::listRoutes(true);
                break;
            case contains($field, 'user_id'):
                $list = User::select(DB::raw("CONCAT(first_name,' ',last_name) AS full_name, id"))->whereNull('vs')->orderBy('first_name')->pluck('full_name', 'id')->all();
                break;
            case contains($field, 'reports_to_id'):
                $list = Position::join("structure__departments","structure__departments.id", "=","structure__positions.department_id")
                    ->select(DB::raw("CONCAT(s_structure__departments.name,' | ',s_structure__positions.name) AS full_name, s_structure__positions.id AS id"))
                    ->orderBy("structure__departments.name")
                    ->orderBy("structure__positions.name")
                    ->pluck('full_name', 'id')
                    ->all();
                break;
            case contains($field, 'aircraft_type_id'):
                $list = AircraftType::pluck('name', 'id')->all();
                break;
            case contains($field, 'region_id'):
                $list = Region::pluck('region', 'id')->all();
                break;
            case contains($field, 'country_id'):
                $list = Country::pluck('country', 'id')
                                ->orderBy("country")
                                ->all();
                break;
            case contains($field, 'city_id'):
                $list = City::pluck('city', 'id')
//                            ->orderBy("country_id")
                            ->orderBy("city")
                            ->all();
                break;
            case contains($field, 'language_id'):
                $list = Language::pluck('language', 'id')->all();
                break;
            case contains($field, 'marital_status_id'):
                $list = MaritalStatus::whereIn("status", ["Single", "Married"])->pluck('status', 'id')->all();
                break;


        }
        return $list;
    }

    protected function getSelectValues($field){
        $list = [];
        switch ($field){
            case contains($field, 'work_type'):
                $list = ['' => 'Select'] + getWorksTypesList();
                break;

            case contains($field, 'off_days'):
                $list = ['' => 'Select'] + [
                    1 => "Monday",
                    2 => "Tuesday",
                    3 => "Wednesday",
                    4 => "Thursday",
                    5 => "Friday",
                    6 => "Saturday",
                    7 => "Sunday",
                ];
                break;

            case contains($field, 'email_notification_id'):
                $list = ['' => 'Select'] + EmailNotification::whereNull("deleted_at")->pluck("name", "id")->all();
                break;

            case contains($field, 'airline_id'):
                $list = ['' => 'Select'] + Airline::listHandlingAirlinesWithCode(IATA, 'id');
                break;

            case contains($field, 'airport_id'):
                $list = ['' => 'Select'] + Airport::listHandlingAirportsWithCode(IATA, 'id');
                break;

            case contains($field, 'flight_route'):
                $list =  ['' => 'Select'] + FlightRoute::listRoutes();
                break;

            case contains($field, 'user_id'):
                $list = ['' => 'Select'] + User::select(DB::raw("CONCAT(first_name,' ',last_name) AS full_name, id"))
                        ->whereNull('deleted_at')
                        ->where(function($sql){
                            $sql->whereNull("users.resigned_date")
                                ->orWhere("users.resigned_date", EMPTY_DATE)
                                ->orWhere("users.resigned_date", ">", date("Y-m-d"));
                        })
                        ->whereNull('vs')
                        ->orderBy('first_name')
                        ->pluck('full_name', 'id')
                        ->all();
                break;

            case contains($field, 'reports_to_id'):
                $list = ['' => 'Select'] +
                        Position::join("structure__departments","structure__departments.id", "=","structure__positions.department_id")
                        ->select(DB::raw("CONCAT(s_structure__departments.name,' | ',s_structure__positions.name) AS full_name, s_structure__positions.id AS id"))
                        ->orderBy("structure__departments.name")
                        ->orderBy("structure__positions.name")
                        ->pluck('full_name', 'id')
                        ->all();
                break;

            case contains($field, 'flight_type_id'):
                $list = ['' => 'Select'] + FlightType::whereNotNull("abbr")->pluck('abbr', 'id')->all();
                break;

            case contains($field, 'region_id'):
                $list = ['' => 'Select'] + Region::pluck('region', 'id')->all();
                break;

            case contains($field, 'country_id'):
                $list = ['' => 'Select'] + Country::pluck('country', 'id')->all();
                break;

            case contains($field, 'city_id'):
                $list = ['' => 'Select'] + City::pluck('city', 'id')->all();
                break;

            case contains($field, 'location_id'):
                $list = ['' => 'Select'] + Location::locationAirports(true);
                break;

            case contains($field, 'nationality_id'):
                $list = ['' => 'Select'] + Nationality::pluck('nationality', 'id')->all();
                break;

            case contains($field, 'language_id'):
                $list = Language::pluck('language', 'id')->all();
                break;

            case contains($field, 'department_id'):
                $list = Department::orderBy("name")->pluck('name', 'id')->all();
                break;

            case contains($field, 'subdepartment_id'):
                $list = SubDepartment::orderBy("name")->pluck('name', 'id')->all();
                break;

            case contains($field, 'position_id'):
                $list = Position::orderBy("name")->pluck('name', 'id')->all();
                break;

            case contains($field, 'marital_status_id'):
                $list = ['' => 'Select'] + MaritalStatus::whereIn("status", ["Single", "Married"])->pluck('status', 'id')->all();
                break;

            case contains($field, 'english_level'):
                $list = [ '' => 'select', 1 => 1, 2 => 2, 3 => 3, 4 => 4, 5 => 5, 6 =>6 ];
                break;

            case contains($field, 'is_'):
                $list = [ null => 'No', 1 => 'Yes'];
                break;

            case contains($field, 'gender'):
                $list = ['' => 'Select', 'male' => 'Male', 'female' => 'Female'];
                break;

            case $field == "year":
                $list = [
                    "Calendar"  => "Calendar",
                    "Working"   => "Working"
                ];
                break;
        }
        return $list;
    }

}
